/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.persistence.repository.embedded.operate;

import com.alibaba.nacos.common.model.RestResult;
import com.alibaba.nacos.common.model.RestResultUtils;
import com.alibaba.nacos.common.utils.CollectionUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.persistence.configuration.condition.ConditionStandaloneEmbedStorage;
import com.alibaba.nacos.persistence.datasource.DataSourceService;
import com.alibaba.nacos.persistence.datasource.DynamicDataSource;
import com.alibaba.nacos.persistence.repository.embedded.operate.BaseDatabaseOperate;
import com.alibaba.nacos.persistence.repository.embedded.sql.ModifyRequest;
import com.alibaba.nacos.sys.utils.DiskUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Component;
import org.springframework.transaction.support.TransactionTemplate;

@Conditional(value={ConditionStandaloneEmbedStorage.class})
@Component
public class StandaloneDatabaseOperateImpl
implements BaseDatabaseOperate {
    private static final Logger LOGGER = LoggerFactory.getLogger(StandaloneDatabaseOperateImpl.class);
    private JdbcTemplate jdbcTemplate;
    private TransactionTemplate transactionTemplate;

    @PostConstruct
    protected void init() {
        DataSourceService dataSourceService = DynamicDataSource.getInstance().getDataSource();
        this.jdbcTemplate = dataSourceService.getJdbcTemplate();
        this.transactionTemplate = dataSourceService.getTransactionTemplate();
        LOGGER.info("use StandaloneDatabaseOperateImpl");
    }

    @Override
    public <R> R queryOne(String sql, Class<R> cls) {
        return this.queryOne(this.jdbcTemplate, sql, cls);
    }

    @Override
    public <R> R queryOne(String sql, Object[] args, Class<R> cls) {
        return this.queryOne(this.jdbcTemplate, sql, args, cls);
    }

    @Override
    public <R> R queryOne(String sql, Object[] args, RowMapper<R> mapper) {
        return this.queryOne(this.jdbcTemplate, sql, args, mapper);
    }

    @Override
    public <R> List<R> queryMany(String sql, Object[] args, RowMapper<R> mapper) {
        return this.queryMany(this.jdbcTemplate, sql, args, mapper);
    }

    @Override
    public <R> List<R> queryMany(String sql, Object[] args, Class<R> rClass) {
        return this.queryMany(this.jdbcTemplate, sql, args, rClass);
    }

    @Override
    public List<Map<String, Object>> queryMany(String sql, Object[] args) {
        return this.queryMany(this.jdbcTemplate, sql, args);
    }

    @Override
    public CompletableFuture<RestResult<String>> dataImport(File file) {
        return CompletableFuture.supplyAsync(() -> {
            RestResult restResult;
            block11: {
                DiskUtils.LineIterator iterator = DiskUtils.lineIterator((File)file);
                try {
                    int batchSize = 1000;
                    ArrayList<String> batchUpdate = new ArrayList<String>(batchSize);
                    ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
                    CopyOnWriteArrayList results = new CopyOnWriteArrayList();
                    while (iterator.hasNext()) {
                        String sql = iterator.next();
                        if (StringUtils.isNotBlank((String)sql)) {
                            batchUpdate.add(sql);
                        }
                        if (batchUpdate.size() != batchSize && iterator.hasNext()) continue;
                        List sqls = batchUpdate.stream().map(s -> {
                            ModifyRequest request = new ModifyRequest();
                            request.setSql((String)s);
                            return request;
                        }).collect(Collectors.toList());
                        futures.add(CompletableFuture.runAsync(() -> results.add(this.doDataImport(this.jdbcTemplate, sqls))));
                        batchUpdate.clear();
                    }
                    CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).join();
                    int code = 500;
                    if (!CollectionUtils.isEmpty(results)) {
                        code = !results.stream().anyMatch(Boolean.FALSE::equals) ? 200 : 500;
                    }
                    restResult = RestResult.builder().withCode(code).withData((Object)"").build();
                    if (iterator == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (iterator != null) {
                            try {
                                iterator.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable ex) {
                        LOGGER.error("An exception occurred when external data was imported into Derby : ", ex);
                        return RestResultUtils.failed((String)ex.getMessage());
                    }
                }
                iterator.close();
            }
            return restResult;
        });
    }

    @Override
    public Boolean update(List<ModifyRequest> modifyRequests, BiConsumer<Boolean, Throwable> consumer) {
        return this.update(this.transactionTemplate, this.jdbcTemplate, modifyRequests, consumer);
    }

    @Override
    public Boolean update(List<ModifyRequest> requestList) {
        return this.update(this.transactionTemplate, this.jdbcTemplate, requestList);
    }
}

