/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.pojo.instance;

import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.naming.spi.generator.InstanceIdGenerator;
import com.alibaba.nacos.core.distributed.id.SnowFlowerIdGenerator;

public class SnowFlakeInstanceIdGenerator
implements InstanceIdGenerator {
    private static final SnowFlowerIdGenerator SNOW_FLOWER_ID_GENERATOR = new SnowFlowerIdGenerator();
    private static volatile boolean initialize = false;
    private static final Object LOCK = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureWorkerIdInitialization() {
        if (!initialize) {
            Object object = LOCK;
            synchronized (object) {
                if (!initialize) {
                    SNOW_FLOWER_ID_GENERATOR.init();
                    initialize = true;
                }
            }
        }
    }

    public String generateInstanceId(Instance instance) {
        this.ensureWorkerIdInitialization();
        return SNOW_FLOWER_ID_GENERATOR.nextId() + "#" + instance.getClusterName() + "#" + instance.getServiceName();
    }

    public String type() {
        return "snowflake";
    }
}

