/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.pojo.instance;

import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.naming.spi.generator.InstanceIdGenerator;
import com.alibaba.nacos.api.utils.StringUtils;
import com.alibaba.nacos.common.spi.NacosServiceLoader;
import java.util.Collection;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;

public class InstanceIdGeneratorManager {
    private static final InstanceIdGeneratorManager INSTANCE = new InstanceIdGeneratorManager();
    private final Map<String, InstanceIdGenerator> generatorMap = new ConcurrentHashMap<String, InstanceIdGenerator>();

    public InstanceIdGeneratorManager() {
        this.init();
    }

    private void init() {
        Collection instanceIdGenerators = NacosServiceLoader.load(InstanceIdGenerator.class);
        for (InstanceIdGenerator instanceIdGenerator : instanceIdGenerators) {
            this.generatorMap.put(instanceIdGenerator.type(), instanceIdGenerator);
        }
    }

    private InstanceIdGenerator getInstanceIdGenerator(String type) {
        if (this.generatorMap.containsKey(type)) {
            return this.generatorMap.get(type);
        }
        throw new NoSuchElementException("The InstanceIdGenerator type is not found ");
    }

    public static String generateInstanceId(Instance instance) {
        String instanceIdGeneratorType = instance.getInstanceIdGenerator();
        if (StringUtils.isBlank((CharSequence)instanceIdGeneratorType)) {
            instanceIdGeneratorType = "simple";
        }
        return INSTANCE.getInstanceIdGenerator(instanceIdGeneratorType).generateInstanceId(instance);
    }
}

