/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.monitor.collector;

import com.alibaba.nacos.common.executor.ExecutorFactory;
import com.alibaba.nacos.naming.core.v2.client.Client;
import com.alibaba.nacos.naming.core.v2.client.manager.impl.ConnectionBasedClientManager;
import com.alibaba.nacos.naming.core.v2.client.manager.impl.EphemeralIpPortClientManager;
import com.alibaba.nacos.naming.core.v2.client.manager.impl.PersistentIpPortClientManager;
import com.alibaba.nacos.naming.monitor.MetricsMonitor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NamingSubAndPubMetricsCollector {
    private static final long DELAY_SECONDS = 5L;
    private static ScheduledExecutorService executorService = ExecutorFactory.newSingleScheduledExecutorService(r -> {
        Thread thread = new Thread(r, "nacos.naming.monitor.NamingSubAndPubMetricsCollector");
        thread.setDaemon(true);
        return thread;
    });

    @Autowired
    public NamingSubAndPubMetricsCollector(ConnectionBasedClientManager connectionBasedClientManager, EphemeralIpPortClientManager ephemeralIpPortClientManager, PersistentIpPortClientManager persistentIpPortClientManager) {
        executorService.scheduleWithFixedDelay(() -> {
            Client client;
            int v1SubscriberCount = 0;
            int v1PublisherCount = 0;
            for (String clientId : ephemeralIpPortClientManager.allClientId()) {
                client = ephemeralIpPortClientManager.getClient(clientId);
                if (null == client) continue;
                v1PublisherCount += client.getAllPublishedService().size();
                v1SubscriberCount += client.getAllSubscribeService().size();
            }
            for (String clientId : persistentIpPortClientManager.allClientId()) {
                client = persistentIpPortClientManager.getClient(clientId);
                if (null == client) continue;
                v1PublisherCount += client.getAllPublishedService().size();
                v1SubscriberCount += client.getAllSubscribeService().size();
            }
            MetricsMonitor.getNamingSubscriber("v1").set(v1SubscriberCount);
            MetricsMonitor.getNamingPublisher("v1").set(v1PublisherCount);
            int v2SubscriberCount = 0;
            int v2PublisherCount = 0;
            for (String clientId : connectionBasedClientManager.allClientId()) {
                Client client2 = connectionBasedClientManager.getClient(clientId);
                if (null == client2) continue;
                v2PublisherCount += client2.getAllPublishedService().size();
                v2SubscriberCount += client2.getAllSubscribeService().size();
            }
            MetricsMonitor.getNamingSubscriber("v2").set(v2SubscriberCount);
            MetricsMonitor.getNamingPublisher("v2").set(v2PublisherCount);
        }, 5L, 5L, TimeUnit.SECONDS);
    }
}

