/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.istio.common;

import com.alibaba.nacos.istio.common.Event;
import com.alibaba.nacos.istio.common.NacosResourceManager;
import com.alibaba.nacos.istio.common.ResourceSnapshot;
import com.alibaba.nacos.istio.mcp.NacosMcpService;
import com.alibaba.nacos.istio.misc.Loggers;
import com.alibaba.nacos.istio.util.IstioExecutor;
import com.alibaba.nacos.istio.xds.NacosXdsService;
import com.alibaba.nacos.sys.utils.ApplicationUtils;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

@Component
public class EventProcessor
implements ApplicationListener<ContextRefreshedEvent> {
    private static final int MAX_WAIT_EVENT_TIME = 100;
    private NacosMcpService nacosMcpService;
    private NacosXdsService nacosXdsService;
    private NacosResourceManager resourceManager;
    private final BlockingQueue<Event> events = new ArrayBlockingQueue<Event>(20);

    public void notify(Event event) {
        try {
            this.events.put(event);
        }
        catch (InterruptedException e) {
            Loggers.MAIN.warn("There are too many events, this event {} will be ignored.", (Object)event.getType());
            Thread.currentThread().interrupt();
        }
    }

    private void handleEvents() {
        Consumer handleEvents = new Consumer("handle events");
        handleEvents.setDaemon(true);
        handleEvents.start();
    }

    public void onApplicationEvent(ContextRefreshedEvent contextRefreshedEvent) {
        if (contextRefreshedEvent.getApplicationContext().getParent() == null) {
            this.checkDependenceReady();
            this.handleEvents();
        }
    }

    private boolean hasClientConnection() {
        return this.nacosMcpService.hasClientConnection() || this.nacosXdsService.hasClientConnection();
    }

    private boolean needNewTask(boolean hasNewEvent, Future<Void> task) {
        return hasNewEvent && (task == null || task.isDone());
    }

    private boolean checkDependenceReady() {
        if (null == this.resourceManager) {
            this.resourceManager = (NacosResourceManager)ApplicationUtils.getBean(NacosResourceManager.class);
        }
        if (null == this.nacosXdsService) {
            this.nacosXdsService = (NacosXdsService)((Object)ApplicationUtils.getBean(NacosXdsService.class));
        }
        if (null == this.nacosMcpService) {
            this.nacosMcpService = (NacosMcpService)ApplicationUtils.getBean(NacosMcpService.class);
        }
        return Objects.nonNull(this.resourceManager) && Objects.nonNull(this.nacosMcpService) && Objects.nonNull((Object)this.nacosXdsService);
    }

    private class Consumer
    extends Thread {
        Consumer(String name) {
            this.setName(name);
        }

        @Override
        public void run() {
            Future<Void> task = null;
            boolean hasNewEvent = false;
            Event lastEvent = null;
            while (true) {
                try {
                    while (true) {
                        Event event;
                        if ((event = (Event)EventProcessor.this.events.poll(100L, TimeUnit.MILLISECONDS)) != null) {
                            hasNewEvent = true;
                            lastEvent = event;
                        }
                        if (!EventProcessor.this.hasClientConnection() || !EventProcessor.this.needNewTask(hasNewEvent, task)) continue;
                        task = IstioExecutor.asyncHandleEvent(new EventHandleTask(lastEvent));
                        hasNewEvent = false;
                        lastEvent = null;
                    }
                }
                catch (InterruptedException e) {
                    Loggers.MAIN.warn("Thread {} is be interrupted.", (Object)this.getName());
                    Thread.currentThread().interrupt();
                    continue;
                }
                break;
            }
        }
    }

    private class EventHandleTask
    implements Callable<Void> {
        private final Event event;

        EventHandleTask(Event event) {
            this.event = event;
        }

        @Override
        public Void call() throws Exception {
            ResourceSnapshot snapshot = EventProcessor.this.resourceManager.createResourceSnapshot();
            EventProcessor.this.nacosXdsService.handleEvent(snapshot, this.event);
            EventProcessor.this.nacosMcpService.handleEvent(snapshot, this.event);
            return null;
        }
    }
}

