/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.auth.ram.injector;

import com.alibaba.nacos.api.naming.utils.NamingUtils;
import com.alibaba.nacos.client.auth.ram.RamContext;
import com.alibaba.nacos.client.auth.ram.identify.StsConfig;
import com.alibaba.nacos.client.auth.ram.identify.StsCredential;
import com.alibaba.nacos.client.auth.ram.identify.StsCredentialHolder;
import com.alibaba.nacos.client.auth.ram.injector.AbstractResourceInjector;
import com.alibaba.nacos.client.auth.ram.utils.SignUtil;
import com.alibaba.nacos.client.utils.LogUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.plugin.auth.api.LoginIdentityContext;
import com.alibaba.nacos.plugin.auth.api.RequestResource;

public class NamingResourceInjector
extends AbstractResourceInjector {
    private static final String SIGNATURE_FILED = "signature";
    private static final String DATA_FILED = "data";
    private static final String AK_FILED = "ak";

    @Override
    public void doInject(RequestResource resource, RamContext context, LoginIdentityContext result) {
        if (context.validate()) {
            try {
                String accessKey = context.getAccessKey();
                String secretKey = context.getSecretKey();
                if (StsConfig.getInstance().isStsOn()) {
                    StsCredential stsCredential = StsCredentialHolder.getInstance().getStsCredential();
                    accessKey = stsCredential.getAccessKeyId();
                    secretKey = stsCredential.getAccessKeySecret();
                    result.setParameter("Spas-SecurityToken", stsCredential.getSecurityToken());
                }
                String signData = this.getSignData(this.getGroupedServiceName(resource));
                String signature = SignUtil.sign(signData, secretKey);
                result.setParameter(SIGNATURE_FILED, signature);
                result.setParameter(DATA_FILED, signData);
                result.setParameter(AK_FILED, accessKey);
            }
            catch (Exception e) {
                LogUtils.NAMING_LOGGER.error("inject ak/sk failed.", (Throwable)e);
            }
        }
    }

    private String getGroupedServiceName(RequestResource resource) {
        if (resource.getResource().contains("@@") || StringUtils.isBlank((CharSequence)resource.getGroup())) {
            return resource.getResource();
        }
        return NamingUtils.getGroupedNameOptional((String)resource.getResource(), (String)resource.getGroup());
    }

    private String getSignData(String serviceName) {
        return StringUtils.isNotEmpty((String)serviceName) ? System.currentTimeMillis() + "@@" + serviceName : String.valueOf(System.currentTimeMillis());
    }
}

