/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.images;

import fr.opensagres.xdocreport.core.XDocReportException;
import fr.opensagres.xdocreport.core.io.IEntryOutputStreamProvider;
import fr.opensagres.xdocreport.core.io.IEntryReaderProvider;
import fr.opensagres.xdocreport.core.io.IEntryWriterProvider;
import fr.opensagres.xdocreport.core.io.IOUtils;
import fr.opensagres.xdocreport.document.DocumentContextHelper;
import fr.opensagres.xdocreport.document.images.IImageHandler;
import fr.opensagres.xdocreport.document.images.IImageProvider;
import fr.opensagres.xdocreport.document.images.IImageRegistry;
import fr.opensagres.xdocreport.document.images.ImageProviderInfo;
import fr.opensagres.xdocreport.template.IContext;
import fr.opensagres.xdocreport.template.formatter.FieldMetadata;
import fr.opensagres.xdocreport.template.formatter.FieldsMetadata;
import fr.opensagres.xdocreport.template.formatter.NullImageBehaviour;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractImageRegistry
implements IImageRegistry {
    private static final String XDOCREPORT_PREFIX = "xdocreport_";
    private List<ImageProviderInfo> imageProviderInfos;
    protected final IEntryReaderProvider readerProvider;
    protected final IEntryWriterProvider writerProvider;
    protected final IEntryOutputStreamProvider outputStreamProvider;
    private final FieldsMetadata fieldsMetadata;
    private final NullImageBehaviour defaultBehaviour;

    public AbstractImageRegistry(IEntryReaderProvider readerProvider, IEntryWriterProvider writerProvider, IEntryOutputStreamProvider outputStreamProvider, FieldsMetadata fieldsMetadata) {
        this.readerProvider = readerProvider;
        this.writerProvider = writerProvider;
        this.outputStreamProvider = outputStreamProvider;
        this.fieldsMetadata = fieldsMetadata;
        this.defaultBehaviour = fieldsMetadata != null ? fieldsMetadata.getBehaviour() : null;
    }

    @Override
    public ImageProviderInfo registerImage(Object image, String fieldName, IContext context) throws XDocReportException, IOException {
        IImageProvider imageProvider = this.getImageProvider(image, fieldName, context);
        if (imageProvider == null) {
            return this.processNullImage(fieldName, imageProvider);
        }
        if (!imageProvider.isValid()) {
            return this.processNullImage(fieldName, imageProvider);
        }
        ImageProviderInfo info = this.createImageProviderInfo(imageProvider);
        this.getImageProviderInfos().add(info);
        return info;
    }

    private ImageProviderInfo processNullImage(String fieldName, IImageProvider imageProvider) throws XDocReportException {
        NullImageBehaviour behaviour = this.getBehaviour(imageProvider, this.getFieldBehaviour(fieldName), this.defaultBehaviour);
        switch (behaviour) {
            case RemoveImageTemplate: {
                return ImageProviderInfo.RemoveImageTemplate;
            }
            case KeepImageTemplate: {
                return ImageProviderInfo.KeepImageTemplate;
            }
        }
        throw new XDocReportException("Image provider for field [" + fieldName + "] cannot be null!");
    }

    private NullImageBehaviour getBehaviour(IImageProvider imageProvider, NullImageBehaviour fieldBehaviour, NullImageBehaviour defaultBehaviour) {
        NullImageBehaviour behaviour = null;
        if (imageProvider != null) {
            behaviour = imageProvider.getBehaviour();
        }
        if (behaviour == null) {
            behaviour = fieldBehaviour;
        }
        if (behaviour == null) {
            behaviour = defaultBehaviour;
        }
        if (behaviour == null) {
            behaviour = NullImageBehaviour.ThrowsError;
        }
        return behaviour;
    }

    private NullImageBehaviour getFieldBehaviour(String fieldName) {
        if (this.fieldsMetadata == null) {
            return null;
        }
        FieldMetadata field = this.fieldsMetadata.getFieldAsImage(fieldName);
        return field != null ? field.getBehaviour() : null;
    }

    private IImageProvider getImageProvider(Object imageProvider, String fieldName, IContext context) throws XDocReportException, IOException {
        if (imageProvider == null) {
            return null;
        }
        if (imageProvider instanceof IImageProvider) {
            return (IImageProvider)imageProvider;
        }
        IImageHandler handler = DocumentContextHelper.getImageHandler(context);
        if (handler != null) {
            FieldMetadata field = this.fieldsMetadata.getFieldAsImage(fieldName);
            return handler.getImageProvider(imageProvider, fieldName, field);
        }
        return null;
    }

    @Override
    public List<ImageProviderInfo> getImageProviderInfos() {
        if (this.imageProviderInfos == null) {
            this.imageProviderInfos = new ArrayList<ImageProviderInfo>();
        }
        return this.imageProviderInfos;
    }

    protected ImageProviderInfo createImageProviderInfo(IImageProvider imageProvider) {
        String imageId = this.getImageId();
        String imageBasePath = this.getImageBasePath();
        String imageFileName = imageId + "." + imageProvider.getImageFormat();
        return new ImageProviderInfo(imageProvider, imageId, imageBasePath, imageFileName);
    }

    protected String getImageId() {
        return XDOCREPORT_PREFIX + this.getImageProviderInfos().size();
    }

    @Override
    public void preProcess() throws XDocReportException {
    }

    @Override
    public void postProcess() throws XDocReportException {
        if (this.imageProviderInfos != null) {
            this.saveBinaryImages();
            this.imageProviderInfos.clear();
            this.imageProviderInfos = null;
        }
    }

    protected void saveBinaryImages() throws XDocReportException {
        for (ImageProviderInfo imageProviderInfo : this.imageProviderInfos) {
            this.saveBinaryImage(imageProviderInfo);
        }
    }

    protected void saveBinaryImage(ImageProviderInfo imageProviderInfo) throws XDocReportException {
        String entryName = this.getImageEntryName(imageProviderInfo);
        OutputStream out = this.outputStreamProvider.getEntryOutputStream(entryName);
        try {
            imageProviderInfo.getImageProvider().write(out);
        }
        catch (IOException e) {
            throw new XDocReportException((Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)out);
        }
    }

    protected String getImageEntryName(ImageProviderInfo imageProviderInfo) {
        return imageProviderInfo.getImageBasePath() + imageProviderInfo.getImageFileName();
    }

    protected abstract String getImageBasePath();

    public String getPath(ImageProviderInfo info, String defaultPath) {
        if (!info.isKeepImageTemplate()) {
            return this.getPath(info);
        }
        return defaultPath;
    }

    protected abstract String getPath(ImageProviderInfo var1);

    @Override
    public String getWidth(ImageProviderInfo info, String defaultWidth) throws IOException {
        if (info.isKeepImageTemplate()) {
            return defaultWidth;
        }
        IImageProvider imageProvider = info.getImageProvider();
        Float width = imageProvider.getWidth(this.getSize(defaultWidth));
        if (width != null) {
            return this.getSize(width.floatValue());
        }
        return defaultWidth;
    }

    @Override
    public String getHeight(ImageProviderInfo info, String defaultHeight) throws IOException {
        if (info.isKeepImageTemplate()) {
            return defaultHeight;
        }
        IImageProvider imageProvider = info.getImageProvider();
        Float height = imageProvider.getHeight(this.getSize(defaultHeight));
        if (height != null) {
            return this.getSize(height.floatValue());
        }
        return defaultHeight;
    }

    public FieldsMetadata getFieldsMetadata() {
        return this.fieldsMetadata;
    }

    public abstract String getSize(float var1);

    public abstract Float getSize(String var1);
}

