/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.arquillian.json;

import fish.payara.arquillian.javax.json.JsonArray;
import fish.payara.arquillian.javax.json.JsonArrayBuilder;
import fish.payara.arquillian.javax.json.JsonBuilderFactory;
import fish.payara.arquillian.javax.json.JsonMergePatch;
import fish.payara.arquillian.javax.json.JsonNumber;
import fish.payara.arquillian.javax.json.JsonObject;
import fish.payara.arquillian.javax.json.JsonObjectBuilder;
import fish.payara.arquillian.javax.json.JsonPatch;
import fish.payara.arquillian.javax.json.JsonPatchBuilder;
import fish.payara.arquillian.javax.json.JsonPointer;
import fish.payara.arquillian.javax.json.JsonReader;
import fish.payara.arquillian.javax.json.JsonReaderFactory;
import fish.payara.arquillian.javax.json.JsonString;
import fish.payara.arquillian.javax.json.JsonStructure;
import fish.payara.arquillian.javax.json.JsonValue;
import fish.payara.arquillian.javax.json.JsonWriter;
import fish.payara.arquillian.javax.json.JsonWriterFactory;
import fish.payara.arquillian.javax.json.spi.JsonProvider;
import fish.payara.arquillian.javax.json.stream.JsonGenerator;
import fish.payara.arquillian.javax.json.stream.JsonGeneratorFactory;
import fish.payara.arquillian.javax.json.stream.JsonParser;
import fish.payara.arquillian.javax.json.stream.JsonParserFactory;
import fish.payara.arquillian.json.BufferPoolImpl;
import fish.payara.arquillian.json.JsonArrayBuilderImpl;
import fish.payara.arquillian.json.JsonBuilderFactoryImpl;
import fish.payara.arquillian.json.JsonGeneratorFactoryImpl;
import fish.payara.arquillian.json.JsonGeneratorImpl;
import fish.payara.arquillian.json.JsonMergePatchImpl;
import fish.payara.arquillian.json.JsonNumberImpl;
import fish.payara.arquillian.json.JsonObjectBuilderImpl;
import fish.payara.arquillian.json.JsonParserFactoryImpl;
import fish.payara.arquillian.json.JsonParserImpl;
import fish.payara.arquillian.json.JsonPatchBuilderImpl;
import fish.payara.arquillian.json.JsonPatchImpl;
import fish.payara.arquillian.json.JsonPointerImpl;
import fish.payara.arquillian.json.JsonReaderFactoryImpl;
import fish.payara.arquillian.json.JsonReaderImpl;
import fish.payara.arquillian.json.JsonStringImpl;
import fish.payara.arquillian.json.JsonWriterFactoryImpl;
import fish.payara.arquillian.json.JsonWriterImpl;
import fish.payara.arquillian.json.api.BufferPool;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class JsonProviderImpl
extends JsonProvider {
    private final BufferPool bufferPool = new BufferPoolImpl();

    @Override
    public JsonGenerator createGenerator(Writer writer) {
        return new JsonGeneratorImpl(writer, this.bufferPool);
    }

    @Override
    public JsonGenerator createGenerator(OutputStream out) {
        return new JsonGeneratorImpl(out, this.bufferPool);
    }

    @Override
    public JsonParser createParser(Reader reader) {
        return new JsonParserImpl(reader, this.bufferPool);
    }

    @Override
    public JsonParser createParser(InputStream in) {
        return new JsonParserImpl(in, this.bufferPool);
    }

    @Override
    public JsonParserFactory createParserFactory(Map<String, ?> config) {
        BufferPool pool = null;
        if (config != null && config.containsKey(BufferPool.class.getName())) {
            pool = (BufferPool)config.get(BufferPool.class.getName());
        }
        if (pool == null) {
            pool = this.bufferPool;
        }
        return new JsonParserFactoryImpl(pool);
    }

    @Override
    public JsonGeneratorFactory createGeneratorFactory(Map<String, ?> config) {
        BufferPool pool;
        boolean prettyPrinting;
        Map<String, Object> providerConfig;
        if (config == null) {
            providerConfig = Collections.emptyMap();
            prettyPrinting = false;
            pool = this.bufferPool;
        } else {
            providerConfig = new HashMap();
            prettyPrinting = JsonProviderImpl.isPrettyPrintingEnabled(config);
            if (prettyPrinting) {
                providerConfig.put("fish.payara.arquillian.javax.json.stream.JsonGenerator.prettyPrinting", true);
            }
            if ((pool = (BufferPool)config.get(BufferPool.class.getName())) != null) {
                providerConfig.put(BufferPool.class.getName(), pool);
            } else {
                pool = this.bufferPool;
            }
            providerConfig = Collections.unmodifiableMap(providerConfig);
        }
        return new JsonGeneratorFactoryImpl(providerConfig, prettyPrinting, pool);
    }

    @Override
    public JsonReader createReader(Reader reader) {
        return new JsonReaderImpl(reader, this.bufferPool);
    }

    @Override
    public JsonReader createReader(InputStream in) {
        return new JsonReaderImpl(in, this.bufferPool);
    }

    @Override
    public JsonWriter createWriter(Writer writer) {
        return new JsonWriterImpl(writer, this.bufferPool);
    }

    @Override
    public JsonWriter createWriter(OutputStream out) {
        return new JsonWriterImpl(out, this.bufferPool);
    }

    @Override
    public JsonWriterFactory createWriterFactory(Map<String, ?> config) {
        BufferPool pool;
        boolean prettyPrinting;
        Map<String, Object> providerConfig;
        if (config == null) {
            providerConfig = Collections.emptyMap();
            prettyPrinting = false;
            pool = this.bufferPool;
        } else {
            providerConfig = new HashMap();
            prettyPrinting = JsonProviderImpl.isPrettyPrintingEnabled(config);
            if (prettyPrinting) {
                providerConfig.put("fish.payara.arquillian.javax.json.stream.JsonGenerator.prettyPrinting", true);
            }
            if ((pool = (BufferPool)config.get(BufferPool.class.getName())) != null) {
                providerConfig.put(BufferPool.class.getName(), pool);
            } else {
                pool = this.bufferPool;
            }
            providerConfig = Collections.unmodifiableMap(providerConfig);
        }
        return new JsonWriterFactoryImpl(providerConfig, prettyPrinting, pool);
    }

    @Override
    public JsonReaderFactory createReaderFactory(Map<String, ?> config) {
        BufferPool pool = null;
        if (config != null && config.containsKey(BufferPool.class.getName())) {
            pool = (BufferPool)config.get(BufferPool.class.getName());
        }
        if (pool == null) {
            pool = this.bufferPool;
        }
        return new JsonReaderFactoryImpl(pool);
    }

    @Override
    public JsonObjectBuilder createObjectBuilder() {
        return new JsonObjectBuilderImpl(this.bufferPool);
    }

    @Override
    public JsonObjectBuilder createObjectBuilder(JsonObject object) {
        return new JsonObjectBuilderImpl(object, this.bufferPool);
    }

    @Override
    public JsonObjectBuilder createObjectBuilder(Map<String, Object> map) {
        return new JsonObjectBuilderImpl(map, this.bufferPool);
    }

    @Override
    public JsonArrayBuilder createArrayBuilder() {
        return new JsonArrayBuilderImpl(this.bufferPool);
    }

    @Override
    public JsonArrayBuilder createArrayBuilder(JsonArray array) {
        return new JsonArrayBuilderImpl(array, this.bufferPool);
    }

    @Override
    public JsonArrayBuilder createArrayBuilder(Collection<?> collection) {
        return new JsonArrayBuilderImpl(collection, this.bufferPool);
    }

    @Override
    public JsonPointer createPointer(String jsonPointer) {
        return new JsonPointerImpl(jsonPointer);
    }

    @Override
    public JsonPatchBuilder createPatchBuilder() {
        return new JsonPatchBuilderImpl();
    }

    @Override
    public JsonPatchBuilder createPatchBuilder(JsonArray array) {
        return new JsonPatchBuilderImpl(array);
    }

    @Override
    public JsonPatch createPatch(JsonArray array) {
        return new JsonPatchImpl(array);
    }

    @Override
    public JsonPatch createDiff(JsonStructure source, JsonStructure target) {
        return new JsonPatchImpl(JsonPatchImpl.diff(source, target));
    }

    @Override
    public JsonMergePatch createMergePatch(JsonValue patch) {
        return new JsonMergePatchImpl(patch);
    }

    @Override
    public JsonMergePatch createMergeDiff(JsonValue source, JsonValue target) {
        return new JsonMergePatchImpl(JsonMergePatchImpl.diff(source, target));
    }

    @Override
    public JsonString createValue(String value) {
        return new JsonStringImpl(value);
    }

    @Override
    public JsonNumber createValue(int value) {
        return JsonNumberImpl.getJsonNumber(value);
    }

    @Override
    public JsonNumber createValue(long value) {
        return JsonNumberImpl.getJsonNumber(value);
    }

    @Override
    public JsonNumber createValue(double value) {
        return JsonNumberImpl.getJsonNumber(value);
    }

    @Override
    public JsonNumber createValue(BigInteger value) {
        return JsonNumberImpl.getJsonNumber(value);
    }

    @Override
    public JsonNumber createValue(BigDecimal value) {
        return JsonNumberImpl.getJsonNumber(value);
    }

    @Override
    public JsonBuilderFactory createBuilderFactory(Map<String, ?> config) {
        BufferPool pool = null;
        if (config != null && config.containsKey(BufferPool.class.getName())) {
            pool = (BufferPool)config.get(BufferPool.class.getName());
        }
        if (pool == null) {
            pool = this.bufferPool;
        }
        return new JsonBuilderFactoryImpl(pool);
    }

    static boolean isPrettyPrintingEnabled(Map<String, ?> config) {
        return config.containsKey("fish.payara.arquillian.javax.json.stream.JsonGenerator.prettyPrinting");
    }
}

