/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.arquillian.jersey.server.model.internal;

import fish.payara.arquillian.inject.Singleton;
import fish.payara.arquillian.jersey.internal.inject.InjectionManager;
import fish.payara.arquillian.jersey.internal.inject.Providers;
import fish.payara.arquillian.jersey.internal.util.collection.LazyValue;
import fish.payara.arquillian.jersey.internal.util.collection.Values;
import fish.payara.arquillian.jersey.server.internal.LocalizationMessages;
import fish.payara.arquillian.jersey.server.model.Invocable;
import fish.payara.arquillian.jersey.server.spi.internal.ResourceMethodInvocationHandlerProvider;
import java.lang.reflect.InvocationHandler;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

@Singleton
public final class ResourceMethodInvocationHandlerFactory
implements ResourceMethodInvocationHandlerProvider {
    private static final InvocationHandler DEFAULT_HANDLER = (target, method, args) -> method.invoke(target, args);
    private static final Logger LOGGER = Logger.getLogger(ResourceMethodInvocationHandlerFactory.class.getName());
    private final LazyValue<Set<ResourceMethodInvocationHandlerProvider>> providers = Values.lazy(() -> Providers.getProviders(injectionManager, ResourceMethodInvocationHandlerProvider.class));

    ResourceMethodInvocationHandlerFactory(InjectionManager injectionManager) {
    }

    @Override
    public InvocationHandler create(Invocable resourceMethod) {
        for (ResourceMethodInvocationHandlerProvider provider : (Set)this.providers.get()) {
            try {
                InvocationHandler handler = provider.create(resourceMethod);
                if (handler == null) continue;
                return handler;
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, LocalizationMessages.ERROR_PROCESSING_METHOD(resourceMethod, provider.getClass().getName()), e);
            }
        }
        return DEFAULT_HANDLER;
    }
}

