/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.arquillian.jersey.server.internal.inject;

import fish.payara.arquillian.jersey.internal.inject.ExtractorException;
import fish.payara.arquillian.jersey.server.internal.inject.MultivaluedParameterExtractor;
import fish.payara.arquillian.ws.rs.ProcessingException;
import fish.payara.arquillian.ws.rs.WebApplicationException;
import fish.payara.arquillian.ws.rs.core.MultivaluedMap;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

final class PrimitiveValueOfExtractor
implements MultivaluedParameterExtractor<Object> {
    private final Method valueOf;
    private final String parameter;
    private final String defaultStringValue;
    private final Object defaultValue;
    private final Object defaultPrimitiveTypeValue;

    public PrimitiveValueOfExtractor(Method valueOf, String parameter, String defaultStringValue, Object defaultPrimitiveTypeValue) {
        this.valueOf = valueOf;
        this.parameter = parameter;
        this.defaultStringValue = defaultStringValue;
        this.defaultValue = defaultStringValue != null ? this.getValue(defaultStringValue) : null;
        this.defaultPrimitiveTypeValue = defaultPrimitiveTypeValue;
    }

    @Override
    public String getName() {
        return this.parameter;
    }

    @Override
    public String getDefaultValueString() {
        return this.defaultStringValue;
    }

    private Object getValue(String v) {
        try {
            return this.valueOf.invoke(null, v);
        }
        catch (InvocationTargetException ex) {
            Throwable target = ex.getTargetException();
            if (target instanceof WebApplicationException) {
                throw (WebApplicationException)target;
            }
            throw new ExtractorException(target);
        }
        catch (Exception ex) {
            throw new ProcessingException(ex);
        }
    }

    @Override
    public Object extract(MultivaluedMap<String, String> parameters) {
        String v = parameters.getFirst(this.parameter);
        if (v != null && !v.trim().isEmpty()) {
            return this.getValue(v);
        }
        if (this.defaultValue != null) {
            return this.defaultValue;
        }
        return this.defaultPrimitiveTypeValue;
    }
}

