/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.arquillian.jersey.server.internal.inject;

import fish.payara.arquillian.inject.Provider;
import fish.payara.arquillian.inject.Singleton;
import fish.payara.arquillian.jersey.internal.inject.Binding;
import fish.payara.arquillian.jersey.internal.inject.Bindings;
import fish.payara.arquillian.jersey.internal.inject.ForeignDescriptor;
import fish.payara.arquillian.jersey.internal.inject.InjectionManager;
import fish.payara.arquillian.jersey.internal.util.collection.Cache;
import fish.payara.arquillian.jersey.model.Parameter;
import fish.payara.arquillian.jersey.process.internal.RequestScoped;
import fish.payara.arquillian.jersey.server.ContainerRequest;
import fish.payara.arquillian.jersey.server.internal.inject.AbstractValueParamProvider;
import fish.payara.arquillian.jersey.server.internal.inject.MultivaluedParameterExtractorProvider;
import fish.payara.arquillian.jersey.server.model.Parameter;
import java.util.function.Function;

@Singleton
final class BeanParamValueParamProvider
extends AbstractValueParamProvider {
    private final InjectionManager injectionManager;

    public BeanParamValueParamProvider(Provider<MultivaluedParameterExtractorProvider> mpep, InjectionManager injectionManager) {
        super(mpep, Parameter.Source.BEAN_PARAM);
        this.injectionManager = injectionManager;
    }

    @Override
    public Function<ContainerRequest, ?> createValueProvider(Parameter parameter) {
        return new BeanParamValueProvider(this.injectionManager, parameter);
    }

    private static final class BeanParamValueProvider
    implements Function<ContainerRequest, Object> {
        private final Parameter parameter;
        private final InjectionManager injectionManager;
        private final Cache<Class<?>, ForeignDescriptor> descriptorCache = new Cache(new Function<Class<?>, ForeignDescriptor>(){

            @Override
            public ForeignDescriptor apply(Class<?> key) {
                return injectionManager.createForeignDescriptor((Binding)Bindings.serviceAsContract(key).in(RequestScoped.class));
            }
        });

        private BeanParamValueProvider(InjectionManager injectionManager, Parameter parameter) {
            this.injectionManager = injectionManager;
            this.parameter = parameter;
        }

        @Override
        public Object apply(ContainerRequest request) {
            Class<?> rawType = this.parameter.getRawType();
            Object fromHk2 = this.injectionManager.getInstance(rawType);
            if (fromHk2 != null) {
                return fromHk2;
            }
            ForeignDescriptor foreignDescriptor = this.descriptorCache.apply(rawType);
            return this.injectionManager.getInstance(foreignDescriptor);
        }
    }
}

