/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.arquillian.jersey.server;

import fish.payara.arquillian.jersey.internal.BootstrapBag;
import fish.payara.arquillian.jersey.internal.BootstrapConfigurator;
import fish.payara.arquillian.jersey.internal.inject.InjectionManager;
import fish.payara.arquillian.jersey.server.ResourceBag;
import fish.payara.arquillian.jersey.server.ResourceConfig;
import fish.payara.arquillian.jersey.server.ServerBootstrapBag;
import fish.payara.arquillian.jersey.server.ServerProperties;
import fish.payara.arquillian.jersey.server.model.Resource;
import java.util.logging.Logger;

class ResourceBagConfigurator
implements BootstrapConfigurator {
    private static final Logger LOGGER = Logger.getLogger(ResourceBagConfigurator.class.getName());

    ResourceBagConfigurator() {
    }

    @Override
    public void init(InjectionManager injectionManager, BootstrapBag bootstrapBag) {
        Resource resource;
        ServerBootstrapBag serverBag = (ServerBootstrapBag)bootstrapBag;
        ResourceConfig runtimeConfig = serverBag.getRuntimeConfig();
        boolean disableValidation = ServerProperties.getValue(runtimeConfig.getProperties(), "jersey.config.server.resource.validation.disable", Boolean.FALSE, Boolean.class);
        ResourceBag.Builder resourceBagBuilder = new ResourceBag.Builder();
        for (Resource resource2 : runtimeConfig.getResources()) {
            resourceBagBuilder.registerProgrammaticResource(resource2);
        }
        for (Class clazz : runtimeConfig.getClasses()) {
            try {
                resource = Resource.from(clazz, disableValidation);
                if (resource == null) continue;
                resourceBagBuilder.registerResource(clazz, resource);
            }
            catch (IllegalArgumentException ex) {
                LOGGER.warning(ex.getMessage());
            }
        }
        for (Object object : runtimeConfig.getSingletons()) {
            try {
                resource = Resource.from(object.getClass(), disableValidation);
                if (resource == null) continue;
                resourceBagBuilder.registerResource(object, resource);
            }
            catch (IllegalArgumentException ex) {
                LOGGER.warning(ex.getMessage());
            }
        }
        serverBag.setResourceBag(resourceBagBuilder.build());
    }
}

