/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.arquillian.jersey.message.filtering;

import fish.payara.arquillian.annotation.Priority;
import fish.payara.arquillian.inject.Singleton;
import fish.payara.arquillian.jersey.message.filtering.SecurityHelper;
import fish.payara.arquillian.jersey.message.filtering.spi.AbstractEntityProcessor;
import fish.payara.arquillian.jersey.message.filtering.spi.EntityGraph;
import fish.payara.arquillian.jersey.message.filtering.spi.EntityProcessor;
import java.lang.annotation.Annotation;
import java.util.Set;

@Singleton
@Priority(value=0x7FFFF447)
final class SecurityEntityProcessor
extends AbstractEntityProcessor {
    SecurityEntityProcessor() {
    }

    @Override
    protected EntityProcessor.Result process(String fieldName, Class<?> fieldClass, Annotation[] fieldAnnotations, Annotation[] annotations, EntityGraph graph) {
        if (annotations.length > 0) {
            Set<String> filteringScopes = SecurityHelper.getFilteringScopes(annotations);
            if (filteringScopes == null) {
                return EntityProcessor.Result.ROLLBACK;
            }
            if (!filteringScopes.isEmpty()) {
                if (fieldName != null) {
                    this.addFilteringScopes(fieldName, fieldClass, filteringScopes, graph);
                } else {
                    this.addGlobalScopes(filteringScopes, graph);
                }
            }
        }
        return EntityProcessor.Result.APPLY;
    }
}

