/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.arquillian.jersey.message.filtering;

import fish.payara.arquillian.jersey.message.filtering.CommonScopeProvider;
import fish.payara.arquillian.jersey.message.filtering.DefaultEntityProcessor;
import fish.payara.arquillian.jersey.message.filtering.EntityFilteringBinder;
import fish.payara.arquillian.jersey.message.filtering.EntityFilteringProcessor;
import fish.payara.arquillian.jersey.message.filtering.EntityFilteringScopeResolver;
import fish.payara.arquillian.jersey.message.filtering.SecurityEntityFilteringFeature;
import fish.payara.arquillian.jersey.message.filtering.SelectableEntityFilteringFeature;
import fish.payara.arquillian.jersey.message.filtering.ServerScopeProvider;
import fish.payara.arquillian.ws.rs.RuntimeType;
import fish.payara.arquillian.ws.rs.core.Configuration;
import fish.payara.arquillian.ws.rs.core.Feature;
import fish.payara.arquillian.ws.rs.core.FeatureContext;

public final class EntityFilteringFeature
implements Feature {
    public static final String ENTITY_FILTERING_SCOPE = "jersey.config.entityFiltering.scope";

    @Override
    public boolean configure(FeatureContext context) {
        Configuration config = context.getConfiguration();
        if (!config.isRegistered(EntityFilteringProcessor.class)) {
            if (!config.isRegistered(EntityFilteringBinder.class)) {
                context.register(new EntityFilteringBinder());
            }
            context.register(EntityFilteringProcessor.class);
            if (!config.isRegistered(DefaultEntityProcessor.class)) {
                context.register(DefaultEntityProcessor.class);
            }
            context.register(EntityFilteringScopeResolver.class);
            if (RuntimeType.SERVER == config.getRuntimeType()) {
                context.register(ServerScopeProvider.class);
            } else {
                context.register(CommonScopeProvider.class);
            }
            return true;
        }
        return false;
    }

    public static boolean enabled(Configuration config) {
        return config.isRegistered(EntityFilteringFeature.class) || config.isRegistered(SecurityEntityFilteringFeature.class) || config.isRegistered(SelectableEntityFilteringFeature.class);
    }
}

