/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.arquillian.jersey.inject.hk2;

import fish.payara.arquillian.hk2.api.Factory;
import fish.payara.arquillian.hk2.api.Injectee;
import fish.payara.arquillian.hk2.api.ServiceHandle;
import fish.payara.arquillian.inject.Singleton;
import fish.payara.arquillian.jersey.internal.inject.ForeignDescriptorImpl;
import fish.payara.arquillian.jersey.internal.inject.InjecteeImpl;
import fish.payara.arquillian.jersey.internal.inject.InjectionResolver;
import fish.payara.arquillian.jersey.internal.util.ReflectionHelper;
import java.lang.annotation.Annotation;

@Singleton
public class InjectionResolverWrapper<T extends Annotation>
implements fish.payara.arquillian.hk2.api.InjectionResolver<T> {
    private final InjectionResolver jerseyResolver;

    InjectionResolverWrapper(InjectionResolver<T> jerseyResolver) {
        this.jerseyResolver = jerseyResolver;
    }

    @Override
    public Object resolve(Injectee injectee, ServiceHandle root) {
        InjecteeImpl injecteeWrapper = new InjecteeImpl();
        injecteeWrapper.setRequiredType(injectee.getRequiredType());
        injecteeWrapper.setParent(injectee.getParent());
        injecteeWrapper.setRequiredQualifiers(injectee.getRequiredQualifiers());
        injecteeWrapper.setOptional(injectee.isOptional());
        injecteeWrapper.setPosition(injectee.getPosition());
        injecteeWrapper.setFactory(ReflectionHelper.isSubClassOf(injectee.getRequiredType(), Factory.class));
        injecteeWrapper.setInjecteeDescriptor(new ForeignDescriptorImpl(injectee.getInjecteeDescriptor()));
        Object instance = this.jerseyResolver.resolve(injecteeWrapper);
        if (injecteeWrapper.isFactory()) {
            return this.asFactory(instance);
        }
        return instance;
    }

    private Factory asFactory(final Object instance) {
        return new Factory(){

            public Object provide() {
                return instance;
            }

            public void dispose(Object instance2) {
            }
        };
    }

    @Override
    public boolean isConstructorParameterIndicator() {
        return this.jerseyResolver.isConstructorParameterIndicator();
    }

    @Override
    public boolean isMethodParameterIndicator() {
        return this.jerseyResolver.isMethodParameterIndicator();
    }
}

