/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.arquillian.jersey.client;

import fish.payara.arquillian.jersey.client.AbortException;
import fish.payara.arquillian.jersey.client.ClientRequest;
import fish.payara.arquillian.jersey.client.ClientResponse;
import fish.payara.arquillian.jersey.client.InboundJaxrsResponse;
import fish.payara.arquillian.jersey.client.internal.routing.ClientResponseMediaTypeDeterminer;
import fish.payara.arquillian.jersey.internal.inject.InjectionManager;
import fish.payara.arquillian.jersey.internal.inject.Providers;
import fish.payara.arquillian.jersey.model.internal.RankedComparator;
import fish.payara.arquillian.jersey.process.internal.AbstractChainableStage;
import fish.payara.arquillian.jersey.process.internal.ChainableStage;
import fish.payara.arquillian.jersey.process.internal.Stage;
import fish.payara.arquillian.ws.rs.ProcessingException;
import fish.payara.arquillian.ws.rs.client.ClientRequestFilter;
import fish.payara.arquillian.ws.rs.client.ClientResponseFilter;
import fish.payara.arquillian.ws.rs.client.ResponseProcessingException;
import fish.payara.arquillian.ws.rs.core.Response;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;

class ClientFilteringStages {
    private ClientFilteringStages() {
    }

    static ChainableStage<ClientRequest> createRequestFilteringStage(InjectionManager injectionManager) {
        RankedComparator comparator = new RankedComparator(RankedComparator.Order.ASCENDING);
        Iterable<ClientRequestFilter> requestFilters = Providers.getAllProviders(injectionManager, ClientRequestFilter.class, comparator);
        return requestFilters.iterator().hasNext() ? new RequestFilteringStage(requestFilters) : null;
    }

    static ChainableStage<ClientRequest> createRequestFilteringStage(ClientRequestFilter firstFilter, InjectionManager injectionManager) {
        RankedComparator comparator = new RankedComparator(RankedComparator.Order.ASCENDING);
        Iterable<ClientRequestFilter> requestFilters = Providers.getAllProviders(injectionManager, ClientRequestFilter.class, comparator);
        if (firstFilter != null && !requestFilters.iterator().hasNext()) {
            return new RequestFilteringStage(Collections.singletonList(firstFilter));
        }
        if (firstFilter != null && requestFilters.iterator().hasNext()) {
            return new RequestFilteringStage(ClientFilteringStages.prependFilter(firstFilter, requestFilters));
        }
        return null;
    }

    static ChainableStage<ClientResponse> createResponseFilteringStage(InjectionManager injectionManager) {
        RankedComparator comparator = new RankedComparator(RankedComparator.Order.DESCENDING);
        Iterable<ClientResponseFilter> responseFilters = Providers.getAllProviders(injectionManager, ClientResponseFilter.class, comparator);
        return responseFilters.iterator().hasNext() ? new ResponseFilterStage(responseFilters) : null;
    }

    private static <T> Iterable<T> prependFilter(final T filter, final Iterable<T> filters) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    final Iterator<T> filterIterator;
                    boolean wasInterceptorFilterNext;
                    {
                        this.filterIterator = filters.iterator();
                        this.wasInterceptorFilterNext = false;
                    }

                    @Override
                    public boolean hasNext() {
                        return !this.wasInterceptorFilterNext || this.filterIterator.hasNext();
                    }

                    @Override
                    public T next() {
                        if (this.wasInterceptorFilterNext) {
                            return this.filterIterator.next();
                        }
                        this.wasInterceptorFilterNext = true;
                        return filter;
                    }
                };
            }
        };
    }

    private static class ResponseFilterStage
    extends AbstractChainableStage<ClientResponse> {
        private final Iterable<ClientResponseFilter> filters;

        private ResponseFilterStage(Iterable<ClientResponseFilter> filters) {
            this.filters = filters;
        }

        @Override
        public Stage.Continuation<ClientResponse> apply(ClientResponse responseContext) {
            try {
                for (ClientResponseFilter filter : this.filters) {
                    filter.filter(responseContext.getRequestContext(), responseContext);
                }
            }
            catch (IOException ex) {
                InboundJaxrsResponse response = new InboundJaxrsResponse(responseContext, null);
                throw new ResponseProcessingException((Response)response, (Throwable)ex);
            }
            return Stage.Continuation.of(responseContext, this.getDefaultNext());
        }
    }

    private static final class RequestFilteringStage
    extends AbstractChainableStage<ClientRequest> {
        private final Iterable<ClientRequestFilter> requestFilters;

        private RequestFilteringStage(Iterable<ClientRequestFilter> requestFilters) {
            this.requestFilters = requestFilters;
        }

        @Override
        public Stage.Continuation<ClientRequest> apply(ClientRequest requestContext) {
            for (ClientRequestFilter filter : this.requestFilters) {
                try {
                    filter.filter(requestContext);
                    Response abortResponse = requestContext.getAbortResponse();
                    if (abortResponse == null) continue;
                    ClientResponseMediaTypeDeterminer determiner = new ClientResponseMediaTypeDeterminer(requestContext.getWorkers());
                    determiner.setResponseMediaTypeIfNotSet(abortResponse, requestContext.getConfiguration());
                    throw new AbortException(new ClientResponse(requestContext, abortResponse));
                }
                catch (IOException ex) {
                    throw new ProcessingException(ex);
                }
            }
            return Stage.Continuation.of(requestContext, this.getDefaultNext());
        }
    }
}

