/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.gui;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.ClassAnnotation;
import edu.umd.cs.findbugs.FieldAnnotation;
import edu.umd.cs.findbugs.MethodAnnotation;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.gui.BugInstanceGroup;
import edu.umd.cs.findbugs.gui.FindBugsFrame;
import java.awt.Color;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

public class BugCellRenderer
extends DefaultTreeCellRenderer {
    private static final BugCellRenderer theInstance = new BugCellRenderer();
    private static final long serialVersionUID = 1L;
    private ImageIcon bugGroupIcon;
    private ImageIcon packageIcon;
    private ImageIcon bugIcon;
    private ImageIcon classIcon;
    private ImageIcon methodIcon;
    private ImageIcon fieldIcon;
    private ImageIcon sourceFileIcon;
    private Object value;

    public static BugCellRenderer instance() {
        return theInstance;
    }

    private BugCellRenderer() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        this.bugGroupIcon = new ImageIcon(classLoader.getResource("edu/umd/cs/findbugs/gui/bug.png"));
        this.packageIcon = new ImageIcon(classLoader.getResource("edu/umd/cs/findbugs/gui/package.png"));
        this.bugIcon = new ImageIcon(classLoader.getResource("edu/umd/cs/findbugs/gui/bug2.png"));
        this.classIcon = new ImageIcon(classLoader.getResource("edu/umd/cs/findbugs/gui/class.png"));
        this.methodIcon = new ImageIcon(classLoader.getResource("edu/umd/cs/findbugs/gui/method.png"));
        this.fieldIcon = new ImageIcon(classLoader.getResource("edu/umd/cs/findbugs/gui/field.png"));
        this.sourceFileIcon = new ImageIcon(classLoader.getResource("edu/umd/cs/findbugs/gui/sourcefile.png"));
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Object obj;
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        this.value = obj = node.getUserObject();
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        if (obj instanceof BugInstance) {
            this.setIcon(this.bugIcon);
        } else if (obj instanceof ClassAnnotation) {
            this.setIcon(this.classIcon);
        } else if (obj instanceof MethodAnnotation) {
            this.setIcon(this.methodIcon);
        } else if (obj instanceof FieldAnnotation) {
            this.setIcon(this.fieldIcon);
        } else if (obj instanceof SourceLineAnnotation) {
            this.setIcon(this.sourceFileIcon);
        } else if (obj instanceof BugInstanceGroup) {
            BugInstanceGroup groupNode = (BugInstanceGroup)obj;
            String groupType = groupNode.getGroupType();
            if (groupType == "By class") {
                this.setIcon(this.classIcon);
            } else if (groupType == "By package") {
                this.setIcon(this.packageIcon);
            } else if (groupType == "By bug type") {
                this.setIcon(this.bugGroupIcon);
            } else if (groupType == "By bug category") {
                this.setIcon(this.bugGroupIcon);
            }
        } else {
            this.setIcon(null);
        }
        return this;
    }

    public Color getTextNonSelectionColor() {
        return this.getCellTextColor();
    }

    private Color getCellTextColor() {
        Color color = Color.BLACK;
        if (this.value instanceof BugInstance) {
            BugInstance bugInstance = (BugInstance)this.value;
            switch (bugInstance.getPriority()) {
                case 4: {
                    color = FindBugsFrame.EXP_PRIORITY_COLOR;
                    break;
                }
                case 3: {
                    color = FindBugsFrame.LOW_PRIORITY_COLOR;
                    break;
                }
                case 2: {
                    color = FindBugsFrame.NORMAL_PRIORITY_COLOR;
                    break;
                }
                case 1: {
                    color = FindBugsFrame.HIGH_PRIORITY_COLOR;
                }
            }
        }
        return color;
    }
}

