/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.Edge;
import edu.umd.cs.findbugs.graph.AbstractVertex;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Visitor;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.GotoInstruction;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.LOOKUPSWITCH;
import org.apache.bcel.generic.TABLESWITCH;
import org.apache.bcel.util.ByteSequence;

public class DuplicateBranches
extends PreorderVisitor
implements Detector {
    private ClassContext classContext;
    private BugReporter bugReporter;

    public DuplicateBranches(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        this.classContext = classContext;
        classContext.getJavaClass().accept((Visitor)this);
    }

    public void visitMethod(Method method) {
        try {
            if (method.getCode() == null) {
                return;
            }
            CFG cfg = this.classContext.getCFG(method);
            Iterator bbi = cfg.blockIterator();
            while (bbi.hasNext()) {
                BasicBlock bb = (BasicBlock)bbi.next();
                int numOutgoing = cfg.getNumOutgoingEdges((AbstractVertex)bb);
                if (numOutgoing == 2) {
                    this.findIfElseDuplicates(cfg, method, bb);
                    continue;
                }
                if (numOutgoing <= 2) continue;
                this.findSwitchDuplicates(cfg, method, bb);
            }
        }
        catch (Exception e) {
            this.bugReporter.logError("Failure examining basic blocks in Duplicate Branches detector", (Throwable)e);
        }
    }

    private void findIfElseDuplicates(CFG cfg, Method method, BasicBlock bb) {
        byte[] elseBytes;
        BasicBlock thenBB = null;
        BasicBlock elseBB = null;
        Iterator iei = cfg.outgoingEdgeIterator((AbstractVertex)bb);
        while (iei.hasNext()) {
            Edge e = (Edge)iei.next();
            if (e.getType() == 1) {
                elseBB = (BasicBlock)e.getTarget();
                continue;
            }
            if (e.getType() != 0) continue;
            thenBB = (BasicBlock)e.getTarget();
        }
        if (thenBB == null || elseBB == null || thenBB.getFirstInstruction() == null || elseBB.getFirstInstruction() == null) {
            return;
        }
        int thenStartPos = thenBB.getFirstInstruction().getPosition();
        int elseStartPos = elseBB.getFirstInstruction().getPosition();
        InstructionHandle thenFinishIns = this.findThenFinish(cfg, thenBB, elseStartPos);
        int thenFinishPos = thenFinishIns.getPosition();
        if (!(thenFinishIns.getInstruction() instanceof GotoInstruction)) {
            return;
        }
        int elseFinishPos = ((GotoInstruction)thenFinishIns.getInstruction()).getTarget().getPosition();
        if (thenFinishPos >= elseStartPos) {
            return;
        }
        if (thenFinishPos - thenStartPos != elseFinishPos - elseStartPos) {
            return;
        }
        byte[] thenBytes = this.getCodeBytes(method, thenStartPos, thenFinishPos);
        if (!Arrays.equals(thenBytes, elseBytes = this.getCodeBytes(method, elseStartPos, elseFinishPos))) {
            return;
        }
        this.bugReporter.reportBug(new BugInstance((Detector)this, "DB_DUPLICATE_BRANCHES", 2).addClass(this.classContext.getJavaClass()).addMethod(this.classContext.getJavaClass(), method).addSourceLineRange(this.classContext, (PreorderVisitor)this, thenBB.getFirstInstruction().getPosition(), thenBB.getLastInstruction().getPosition()).addSourceLineRange(this.classContext, (PreorderVisitor)this, elseBB.getFirstInstruction().getPosition(), elseBB.getLastInstruction().getPosition()));
    }

    private void findSwitchDuplicates(CFG cfg, Method method, BasicBlock bb) {
        Iterator iei = cfg.outgoingEdgeIterator((AbstractVertex)bb);
        int[] switchPos = new int[cfg.getNumOutgoingEdges((AbstractVertex)bb) + 1];
        int idx = 0;
        while (iei.hasNext()) {
            InstructionHandle firstIns;
            BasicBlock target;
            Edge e = (Edge)iei.next();
            if (2 == e.getType()) {
                target = (BasicBlock)e.getTarget();
                firstIns = target.getFirstInstruction();
                if (firstIns == null) {
                    return;
                }
                switchPos[idx++] = firstIns.getPosition();
                continue;
            }
            if (3 == e.getType()) {
                target = (BasicBlock)e.getTarget();
                firstIns = target.getFirstInstruction();
                if (firstIns == null) {
                    return;
                }
                switchPos[idx++] = firstIns.getPosition();
                continue;
            }
            return;
        }
        Arrays.sort(switchPos);
        if (switchPos.length < 2) {
            return;
        }
        HashMap<BigInteger, LinkedList<Integer>> map = new HashMap<BigInteger, LinkedList<Integer>>();
        for (int i = 0; i < switchPos.length - 1; ++i) {
            if (switchPos[i] + 1 >= switchPos[i + 1]) continue;
            byte[] clause = this.getCodeBytes(method, switchPos[i], switchPos[i + 1]);
            BigInteger clauseAsInt = new BigInteger(clause);
            LinkedList<Integer> values = (LinkedList<Integer>)map.get(clauseAsInt);
            if (values == null) {
                values = new LinkedList<Integer>();
                map.put(clauseAsInt, values);
            }
            values.add(new Integer(i));
        }
        Iterator i$ = map.values().iterator();
        while (i$.hasNext()) {
            Collection clauses = (Collection)i$.next();
            if (clauses.size() <= 1) continue;
            BugInstance bug = new BugInstance((Detector)this, "DB_DUPLICATE_SWITCH_CLAUSES", 3).addClass(this.classContext.getJavaClass()).addMethod(this.classContext.getJavaClass(), method);
            Iterator i$2 = clauses.iterator();
            while (i$2.hasNext()) {
                int i = (Integer)i$2.next();
                bug.addSourceLineRange(this.classContext, (PreorderVisitor)this, switchPos[i], switchPos[i + 1] - 1);
            }
            this.bugReporter.reportBug(bug);
        }
    }

    private byte[] getCodeBytes(Method m, int start, int end) {
        byte[] code = m.getCode().getCode();
        byte[] bytes = new byte[end - start];
        System.arraycopy(code, start, bytes, 0, end - start);
        try {
            int pos;
            ByteSequence sequence = new ByteSequence(code);
            while (sequence.available() > 0 && sequence.getIndex() < start) {
                Instruction.readInstruction((ByteSequence)sequence);
            }
            while (sequence.available() > 0 && (pos = sequence.getIndex()) < end) {
                BranchInstruction bi;
                int offset;
                int target;
                Instruction ins = Instruction.readInstruction((ByteSequence)sequence);
                if (!(ins instanceof BranchInstruction) || ins instanceof TABLESWITCH || ins instanceof LOOKUPSWITCH || (target = (offset = (bi = (BranchInstruction)ins).getIndex()) + pos) < end) continue;
                byte hiByte = (byte)(target >> 8 & 0xFF);
                byte loByte = (byte)(target & 0xFF);
                bytes[pos + bi.getLength() - 2 - start] = hiByte;
                bytes[pos + bi.getLength() - 1 - start] = loByte;
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return bytes;
    }

    private InstructionHandle findThenFinish(CFG cfg, BasicBlock thenBB, int elsePos) {
        InstructionHandle inst = thenBB.getFirstInstruction();
        while (inst == null) {
            Iterator ie = cfg.outgoingEdgeIterator((AbstractVertex)thenBB);
            while (ie.hasNext()) {
                Edge e = (Edge)ie.next();
                if (e.getType() != 0) continue;
                thenBB = (BasicBlock)e.getTarget();
                break;
            }
            inst = thenBB.getFirstInstruction();
        }
        InstructionHandle lastIns = inst;
        while (inst.getPosition() < elsePos) {
            lastIns = inst;
            inst = inst.getNext();
        }
        return lastIns;
    }

    public void report() {
    }
}

