/*
 * Decompiled with CFR 0.152.
 */
package eu.rekawek.toxiproxy.model.toxic;

import com.google.gson.JsonObject;
import eu.rekawek.toxiproxy.HttpClient;
import eu.rekawek.toxiproxy.model.Toxic;
import eu.rekawek.toxiproxy.model.ToxicDirection;
import eu.rekawek.toxiproxy.model.ToxicType;
import java.io.IOException;

public class Slicer
extends Toxic {
    private long averageSize;
    private long sizeVariation;
    private long delay;

    public Slicer(HttpClient httpClient, String toxicListPath, String name, ToxicDirection stream, long averageSize, long delay) throws IOException {
        super(httpClient, toxicListPath, name, stream);
        this.averageSize = averageSize;
        this.delay = delay;
        this.createToxic(toxicListPath);
    }

    public Slicer(HttpClient httpClient, String path, JsonObject json) {
        super(httpClient, path, json);
    }

    @Override
    protected void setAttributes(JsonObject attributes) {
        this.averageSize = attributes.get("average_size").getAsLong();
        this.sizeVariation = attributes.get("size_variation").getAsLong();
        this.delay = attributes.get("delay").getAsLong();
    }

    @Override
    protected JsonObject getAttributes() {
        JsonObject attr = new JsonObject();
        attr.addProperty("average_size", (Number)this.averageSize);
        attr.addProperty("size_variation", (Number)this.sizeVariation);
        attr.addProperty("delay", (Number)this.delay);
        return attr;
    }

    @Override
    protected ToxicType getType() {
        return ToxicType.SLICER;
    }

    public long getAverageSize() {
        return this.averageSize;
    }

    public long getSizeVariation() {
        return this.sizeVariation;
    }

    public long getDelay() {
        return this.delay;
    }

    public Slicer setAverageSize(long averageSize) throws IOException {
        this.postAttribute("average_size", averageSize);
        return this;
    }

    public Slicer setSizeVariation(long sizeVariation) throws IOException {
        this.postAttribute("size_variation", sizeVariation);
        return this;
    }

    public Slicer setDelay(long delay) throws IOException {
        this.postAttribute("delay", delay);
        return this;
    }
}

