/*
 * Decompiled with CFR 0.152.
 */
package eu.rekawek.toxiproxy.model;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import eu.rekawek.toxiproxy.HttpClient;
import eu.rekawek.toxiproxy.model.ToxicDirection;
import eu.rekawek.toxiproxy.model.ToxicType;
import java.io.IOException;

public abstract class Toxic {
    private HttpClient httpClient;
    private String path;
    private String name;
    private ToxicDirection stream;
    private float toxicity;

    public Toxic(HttpClient httpClient, String toxicListPath, String name, ToxicDirection stream) {
        this.httpClient = httpClient;
        this.path = toxicListPath + "/" + name;
        this.name = name;
        this.stream = stream;
        this.toxicity = 1.0f;
    }

    public Toxic(HttpClient httpClient, String path, JsonObject json) {
        this.httpClient = httpClient;
        this.path = path;
        this.setFromJson(json);
    }

    protected abstract void setAttributes(JsonObject var1);

    protected abstract JsonObject getAttributes();

    protected abstract ToxicType getType();

    protected void createToxic(String toxicListPath) throws IOException {
        JsonObject toxicJson = new JsonObject();
        toxicJson.addProperty("name", this.name);
        toxicJson.addProperty("stream", this.stream.name().toLowerCase());
        toxicJson.addProperty("toxicity", (Number)Float.valueOf(this.toxicity));
        toxicJson.addProperty("type", this.getType().name().toLowerCase());
        toxicJson.add("attributes", (JsonElement)this.getAttributes());
        this.setFromJson(this.httpClient.post(toxicListPath, toxicJson));
    }

    protected void postAttribute(String name, long value) throws IOException {
        JsonObject toxicJson = new JsonObject();
        JsonObject attr = new JsonObject();
        attr.addProperty(name, (Number)value);
        toxicJson.add("attributes", (JsonElement)attr);
        this.setFromJson(this.httpClient.post(this.path, toxicJson));
    }

    private void setFromJson(JsonObject json) {
        this.name = json.get("name").getAsString();
        this.stream = ToxicDirection.valueOf(json.get("stream").getAsString().toUpperCase());
        this.toxicity = json.get("toxicity").getAsFloat();
        this.setAttributes(json.getAsJsonObject("attributes"));
    }

    public void setToxicity(float toxicity) throws IOException {
        this.setFromJson(this.httpClient.post(this.path, "toxicity", toxicity));
    }

    public String getName() {
        return this.name;
    }

    public ToxicDirection getStream() {
        return this.stream;
    }

    public float getToxicity() {
        return this.toxicity;
    }

    public void remove() throws IOException {
        this.httpClient.delete(this.path);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": name=" + this.getName() + ", stream=" + (Object)((Object)this.getStream());
    }
}

