/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.mima.runtime.standalonestatic;

import eu.maveniverse.maven.mima.context.Lookup;
import eu.maveniverse.maven.mima.context.MavenUserHome;
import eu.maveniverse.maven.mima.runtime.shared.PreBoot;
import eu.maveniverse.maven.mima.runtime.standalonestatic.ProfileSelectorSupplier;
import eu.maveniverse.maven.mima.runtime.standalonestatic.SettingsBuilderSupplier;
import eu.maveniverse.maven.mima.runtime.standalonestatic.SettingsDecrypterSupplier;
import java.util.Objects;
import java.util.Optional;
import org.apache.maven.model.profile.ProfileSelector;
import org.apache.maven.settings.building.SettingsBuilder;
import org.apache.maven.settings.crypto.SettingsDecrypter;

public class StaticLookup
implements Lookup {
    private final ProfileSelector profileSelector;
    private final SettingsBuilder settingsBuilder;
    private final SettingsDecrypter settingsDecrypter;

    public StaticLookup(PreBoot preBoot) {
        Objects.requireNonNull(preBoot);
        this.profileSelector = new ProfileSelectorSupplier().get();
        this.settingsBuilder = new SettingsBuilderSupplier().get();
        this.settingsDecrypter = new SettingsDecrypterSupplier((MavenUserHome)preBoot.getMavenUserHome()).get();
    }

    public <T> Optional<T> lookup(Class<T> type) {
        if (type.isAssignableFrom(ProfileSelector.class)) {
            return Optional.of(this.profileSelector);
        }
        if (type.isAssignableFrom(SettingsBuilder.class)) {
            return Optional.of(this.settingsBuilder);
        }
        if (type.isAssignableFrom(SettingsDecrypter.class)) {
            return Optional.of(this.settingsDecrypter);
        }
        return Optional.empty();
    }

    public <T> Optional<T> lookup(Class<T> type, String name) {
        if ("".equals(name) || "default".equals(name)) {
            return this.lookup(type);
        }
        return Optional.empty();
    }
}

