/*
 * Decompiled with CFR 0.152.
 */
package edu.minilive.wedu.util;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.AntPathMatcher;

public final class PermitMatcherUtil {
    private static final Logger logger = LoggerFactory.getLogger(PermitMatcherUtil.class);
    private static AntPathMatcher urlMatcher = new AntPathMatcher();

    public static boolean hasPrivilege(List<String> permitlist, String requestUrl) {
        if (requestUrl == null || "".equals(requestUrl)) {
            return false;
        }
        if (requestUrl.indexOf("?") != -1) {
            requestUrl = requestUrl.substring(0, requestUrl.indexOf("?"));
        }
        boolean match = false;
        for (String permitUrl : permitlist) {
            if (permitUrl == null || StringUtils.isEmpty((String)permitUrl)) continue;
            match = urlMatcher.match(permitUrl, requestUrl);
            if (logger.isInfoEnabled()) {
                logger.info(String.format("\u6743\u9650[%s]--[%s]=%s", permitUrl, requestUrl, match));
            }
            if (!match) continue;
            return true;
        }
        return match;
    }
}

