/*
 * Decompiled with CFR 0.152.
 */
package edu.minilive.wedu.util;

import edu.ecompus.core.util.EnvProperUtil;
import edu.minilive.wedu.module.SO.MediaInfoSO;
import edu.minilive.wedu.module.SO.StreamGobblerSO;
import edu.minilive.wedu.module.SO.VideoConvertParamersSO;
import edu.minilive.wedu.util.CommonUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FFmpegTransUtil {
    private static Logger logger = LoggerFactory.getLogger(FFmpegTransUtil.class);

    public static synchronized int ffmpegTrans2MP4(String sourceFile, String targetFile, String wh, String rate) {
        VideoConvertParamersSO vp = new VideoConvertParamersSO();
        vp.setVcodec("libx264");
        vp.setVprofile("high");
        vp.setPreset("slow");
        vp.setAcodec("libfaac");
        vp.setAr("44100");
        vp.setAc("2");
        vp.setKeyint_min("12");
        vp.setG("24");
        vp.setPass("1");
        vp.setToFormat("mp4");
        vp.setINPUT(sourceFile);
        vp.setOUTPUT(targetFile);
        vp.setB(rate);
        vp.setMaxrate(rate);
        vp.setToHeight(wh);
        return FFmpegTransUtil.ffmpegTrans(vp);
    }

    public static synchronized int ffmpegTrans2FLV(String sourceFile, String targetFile, String wh, String rate) {
        VideoConvertParamersSO vp = new VideoConvertParamersSO();
        vp.setVcodec("libx264");
        vp.setVprofile("high");
        vp.setPreset("slow");
        vp.setAcodec("libfaac");
        vp.setAr("44100");
        vp.setAc("2");
        vp.setKeyint_min("12");
        vp.setG("24");
        vp.setPass("1");
        vp.setINPUT(sourceFile);
        vp.setOUTPUT(targetFile);
        vp.setB(rate);
        vp.setMaxrate(rate);
        vp.setToHeight(wh);
        return FFmpegTransUtil.ffmpegTrans(vp);
    }

    public static synchronized int ffmpegTrans(VideoConvertParamersSO vp) {
        if (vp == null) {
            logger.info("[0.0] VideoConvertParamers IS NULL");
            return 4;
        }
        logger.info("[0.1] \u6e90\u6587\u4ef6:" + vp.getINPUT());
        File targetDir = new File(vp.getOUTPUT());
        try {
            logger.info("[1.1] \u521b\u5efa\u76ee\u5f55\u6587\u4ef6:" + targetDir.getParentFile().mkdirs());
        }
        catch (Exception e) {
            // empty catch block
        }
        targetDir = null;
        StringBuffer commend = new StringBuffer();
        commend.append(EnvProperUtil.getFFmpegUrl()).append(" ");
        commend.append(vp.generateFFMpegCommend());
        logger.info("[2.2]\u5f00\u59cb\u8f6c\u6362" + (vp.getToFormat() != null ? vp.getToFormat() : "FLV") + "\u89c6\u9891....");
        logger.info(commend.toString());
        try {
            Process process = Runtime.getRuntime().exec(commend.toString());
            StreamGobblerSO errorGobbler = new StreamGobblerSO(process.getErrorStream(), "ERROR");
            StreamGobblerSO outputGobbler = new StreamGobblerSO(process.getInputStream(), "OUTPUT");
            errorGobbler.start();
            outputGobbler.start();
            process.waitFor();
            logger.info("[2.3]\u8f6c\u6362\u7ed3\u675f *********");
            process.destroy();
            process = null;
            File targetFile = new File(vp.getOUTPUT());
            if (targetFile.exists()) {
                return 1;
            }
            errorGobbler = null;
            outputGobbler = null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return 4;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return 4;
        }
        return 4;
    }

    public static synchronized boolean ffmpegTransImage(String videoPath, String targetImagePath, String ss, String screenshot) {
        if (ss == null || "".equals(ss)) {
            ss = "38";
        }
        if (screenshot == null || "".equals(screenshot)) {
            screenshot = "290x180";
        }
        StringBuffer commend = new StringBuffer();
        commend.append(EnvProperUtil.getFFmpegUrl());
        commend.append(" -i ");
        commend.append(videoPath);
        commend.append(" -y");
        commend.append(" -f image2");
        commend.append(" -ss ").append(ss);
        commend.append(" -t 0.001");
        commend.append(" -s ").append(screenshot);
        commend.append(" -vframes 1 ");
        commend.append(" ").append(targetImagePath);
        logger.info(commend.toString());
        try {
            Process process = Runtime.getRuntime().exec(commend.toString());
            StreamGobblerSO errorGobbler = new StreamGobblerSO(process.getErrorStream(), "ERROR");
            StreamGobblerSO outputGobbler = new StreamGobblerSO(process.getInputStream(), "OUTPUT");
            errorGobbler.start();
            outputGobbler.start();
            process.waitFor();
            process.destroy();
            process = null;
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static synchronized boolean FlvRepair(String videoPath, String targetPath) {
        StringBuffer commend = new StringBuffer();
        commend.append(EnvProperUtil.getYamdiUrl());
        commend.append(" -i ");
        commend.append(videoPath);
        commend.append(" -o ");
        commend.append(targetPath);
        logger.info(commend.toString());
        try {
            Process process = Runtime.getRuntime().exec(commend.toString());
            StreamGobblerSO outputGobbler = new StreamGobblerSO(process.getInputStream(), "OUTPUT");
            outputGobbler.start();
            process.waitFor();
            outputGobbler = null;
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static synchronized boolean MP4Repair(String videoPath, String targetPath) {
        StringBuffer commend = new StringBuffer();
        commend.append(EnvProperUtil.getQtfaststartUrl());
        commend.append(" ").append(videoPath);
        commend.append(" ").append(targetPath);
        logger.info(commend.toString());
        try {
            Process process = Runtime.getRuntime().exec(commend.toString());
            StreamGobblerSO outputGobbler = new StreamGobblerSO(process.getInputStream(), "OUTPUT");
            outputGobbler.start();
            process.waitFor();
            outputGobbler = null;
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static synchronized MediaInfoSO getMediaInfo(String inputfile) {
        MediaInfoSO mi = new MediaInfoSO();
        String info = FFmpegTransUtil.processMedia(inputfile);
        if ("".equals(info)) {
            return mi;
        }
        Perl5Compiler compiler = new Perl5Compiler();
        try {
            Pattern patternAudio;
            Perl5Matcher matcherAudio;
            String regexVideo;
            Pattern patternVideo;
            Perl5Matcher matcherVideo;
            String regexDuration = "Duration: (.*?), start: (.*?), bitrate: (\\d*) kb\\/s";
            String regexAudio = "Audio: (\\w*), (\\d*) Hz";
            Pattern patternDuration = compiler.compile(regexDuration, 1);
            Perl5Matcher matcherDuration = new Perl5Matcher();
            if (matcherDuration.contains(info, patternDuration)) {
                MatchResult re = matcherDuration.getMatch();
                System.out.println("\u63d0\u53d6\u65f6\u957f\u5b57\u7b26  ===" + re.group(1));
                mi.setDuration(CommonUtil.Duration2long(re.group(1)));
                System.out.println("\u63d0\u53d6\u51fa\u65f6\u957f\u6570\u5b57  ===" + mi.getDuration());
                mi.setStartTime(re.group(2));
                System.out.println("\u5f00\u59cb\u65f6\u95f4        =====" + mi.getStartTime());
                mi.setBitrate(CommonUtil.str2long(re.group(3)));
                System.out.println("bitrate \u7801\u7387 \u5355\u4f4d kb==" + mi.getBitrate());
            }
            if ((matcherVideo = new Perl5Matcher()).contains(info, patternVideo = compiler.compile(regexVideo = "Video: (.*?), (.*?), (.*?)[,\\s]", 1))) {
                MatchResult re = matcherVideo.getMatch();
                System.out.println("\u7f16\u7801\u683c\u5f0f ===" + re.group(1));
                mi.setVideoFormat(re.group(2));
                System.out.println("\u89c6\u9891\u683c\u5f0f===" + mi.getVideoFormat());
                System.out.println(" \u5206\u8fa8\u7387===" + re.group(3));
                mi.setVideoWidth(CommonUtil.getVideoMesh(re.group(3), 0, 640L));
                mi.setVideoHeight(CommonUtil.getVideoMesh(re.group(3), 1, 480L));
                System.out.println(" \u5206\u8fa8\u7387-\u5bbd===" + mi.getVideoWidth());
                System.out.println(" \u5206\u8fa8\u7387-\u9ad8===" + mi.getVideoHeight());
            }
            if ((matcherAudio = new Perl5Matcher()).contains(info, patternAudio = compiler.compile(regexAudio, 1))) {
                MatchResult re = matcherAudio.getMatch();
                mi.setAudioFormat(re.group(1));
                mi.setAudioBitRate(CommonUtil.getAudioHZ(re.group(2)));
            }
        }
        catch (MalformedPatternException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mi;
    }

    private static String processMedia(String inputPath) {
        ArrayList<String> commend = new ArrayList<String>();
        commend.add(EnvProperUtil.getFFmpegUrl());
        commend.add("-i");
        commend.add(inputPath);
        logger.info(((Object)commend).toString());
        try {
            ProcessBuilder builder = new ProcessBuilder(new String[0]);
            builder.command(commend);
            builder.redirectErrorStream(true);
            Process p = builder.start();
            BufferedReader buf = null;
            String line = null;
            buf = new BufferedReader(new InputStreamReader(p.getInputStream()));
            StringBuffer sb = new StringBuffer();
            while ((line = buf.readLine()) != null) {
                sb.append(line);
            }
            p.waitFor();
            return sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }
}

