/*
 * Decompiled with CFR 0.152.
 */
package edu.minilive.wedu.util;

import com.google.gson.Gson;
import edu.ecompus.core.util.EnvProperUtil;
import edu.ecompus.core.util.FileUtil;
import edu.minilive.wedu.util.StringUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.web.multipart.MultipartFile;

public class CommonUtil {
    private static Gson gson = new Gson();
    private static String[] units = new String[]{"\u96f6", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d", "\u5341"};
    private static String[] weeks = new String[]{"\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u65e5"};

    public static String object2json(Object object) {
        return gson.toJson(object);
    }

    public static String codemessage2json(String code, String message) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("code", code);
        map.put("msg", message);
        return CommonUtil.getJsonResult(map);
    }

    public static String getJsonResult(Map<String, String> map) {
        return gson.toJson(map);
    }

    public static String code2json(String code, Map<String, String> jsondata) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("code", code);
        map.put("json", gson.toJson(jsondata));
        return gson.toJson(map);
    }

    public static String code2jlist(String code, List list) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("code", code);
        map.put("list", gson.toJson((Object)list));
        return gson.toJson(map);
    }

    public static String code2json(String code, String message) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("code", code);
        map.put("msg", message);
        return gson.toJson(map);
    }

    public static String code2data(String code, String objctName, Object objct) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("code", code);
        if (objctName == null || !"".equals(objctName)) {
            objctName = "data";
        }
        map.put(objctName, gson.toJson(objct));
        return gson.toJson(map);
    }

    public static String clickNum2Text(long clickNum) {
        DecimalFormat formater = new DecimalFormat("###,###");
        return formater.format(clickNum);
    }

    public static String int2ChineseNum(int num) {
        if (num > 11) {
            return String.valueOf(num);
        }
        return units[num];
    }

    public static long str2long(String strlong) {
        try {
            if ("".equals(strlong.replaceAll(" ", ""))) {
                return 0L;
            }
            return Long.valueOf(strlong);
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public static long getVideoMesh(String video, int idx, Long dv) throws Exception {
        Long _value;
        if (StringUtil.isEmpty(video)) {
            return dv;
        }
        String[] arr = video.split("x");
        if (arr.length > idx && (_value = Long.valueOf(CommonUtil.str2long(arr[idx]))) > 0L) {
            return _value;
        }
        return dv;
    }

    public static long Duration2long(String duration) throws Exception {
        long result = 0L;
        String[] arr = duration.split(":");
        result += CommonUtil.str2long(arr[0]) * 3600L;
        result += CommonUtil.str2long(arr[1]) * 60L;
        result = (long)((float)result + Float.valueOf(arr[arr.length - 1]).floatValue());
        return result *= 1000L;
    }

    public static String Duration2bit(Long duration) {
        try {
            long ld = duration / 1000L;
            ld %= 31536000L;
            ld %= 2592000L;
            long hour = (ld %= 86400L) / 3600L;
            long min = (ld %= 3600L) / 60L;
            long sec = ld %= 60L;
            String result = "";
            result = result + (sec >= 10L ? "" : "0") + sec;
            result = (min > 0L ? (min >= 10L ? "" : "0") + min + ":" : "00:") + result;
            result = (hour > 0L ? (hour >= 10L ? "" : "0") + hour + ":" : "") + result;
            return result;
        }
        catch (Exception e) {
            return "00:00";
        }
    }

    public static float getAudioHZ(String ahz) throws Exception {
        float result = Float.valueOf(ahz).floatValue();
        return result /= 1000.0f;
    }

    public static String filesize2mb(long filesize) {
        if (filesize > 1024L && filesize < 0x100000L) {
            return String.format("%s KB", filesize / 1024L);
        }
        if (filesize >= 0x100000L && filesize < 0x100000L) {
            return String.format("%s MB", filesize / 1024L / 1024L);
        }
        return String.format("%s B", filesize);
    }

    public static Long long2mb(long filesize) {
        return filesize / 1024L / 1024L;
    }

    public static String b2mb(long filesize) {
        double r = 0.0;
        String sbyte = "";
        if (filesize > 0x10000000000L) {
            sbyte = "T";
            r = Math.round(filesize / 1024L / 1024L / 1024L / 1024L * 10L) / 10;
        } else if (filesize > 0x4B400000L) {
            sbyte = "G";
            r = Math.round(filesize / 1024L / 1024L / 1024L * 10L) / 10;
        } else if (filesize > 0x100000L) {
            sbyte = "M";
            r = Math.round(filesize / 1024L / 1024L * 10L) / 10;
        } else if (filesize > 1024L) {
            sbyte = "K";
            r = Math.round(filesize / 1024L * 10L) / 10;
        } else {
            sbyte = "";
            r = filesize;
        }
        return r + sbyte;
    }

    public static String ib2mb(long filesize) {
        int r = 0;
        String sbyte = "";
        if (filesize > 0x10000000000L) {
            sbyte = "T";
            r = Math.round(filesize / 1024L / 1024L / 1024L / 1024L);
        } else if (filesize > 0x4B400000L) {
            sbyte = "G";
            r = Math.round(filesize / 1024L / 1024L / 1024L);
        } else if (filesize > 0x100000L) {
            sbyte = "M";
            r = Math.round(filesize / 1024L / 1024L);
        } else if (filesize > 1024L) {
            sbyte = "K";
            r = Math.round(filesize / 1024L);
        } else {
            sbyte = "";
            r = Integer.valueOf(String.valueOf(filesize));
        }
        return r + sbyte;
    }

    public static String classIcon(String file) {
        String ext = FileUtil.getExtension((String)file).toLowerCase();
        System.out.println("file=" + file + "  ext=" + ext);
        return "vd_" + ext;
    }

    public static String dateformat(Date date, String format) {
        SimpleDateFormat _format = new SimpleDateFormat(format);
        return _format.format(date);
    }

    public static String getMondayDate() {
        GregorianCalendar currentDate = new GregorianCalendar();
        currentDate.add(5, CommonUtil.getStartWeekNumber());
        Date monday = currentDate.getTime();
        return CommonUtil.dateformat(monday, "yyyy-MM-dd");
    }

    public static String getWeekDateStr(int week) {
        Date end = CommonUtil.getWeekDate(week);
        return CommonUtil.dateformat(end, "yyyy-MM-dd");
    }

    public static Date getWeekDate(int week) {
        Calendar calendar = Calendar.getInstance();
        int min = CommonUtil.getStartWeekNumber();
        calendar.add(7, min);
        calendar.add(7, week);
        return calendar.getTime();
    }

    public static int getWeek(Date date) {
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        int dayOfWeek = cd.get(7) - 1;
        if (dayOfWeek == 0) {
            dayOfWeek = 7;
        }
        if (dayOfWeek == 1) {
            return 0;
        }
        return 1 - dayOfWeek;
    }

    public static String getWeekStr(String date) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Date dt1 = df.parse(date);
            return weeks[Math.abs(CommonUtil.getWeek(dt1))];
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "";
        }
    }

    public static int getStartWeekNumber() {
        return CommonUtil.getWeek(new Date());
    }

    public static int compare_date(String DATE1, String DATE2) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Date dt1 = df.parse(DATE1);
            Date dt2 = df.parse(DATE2);
            if (dt1.getTime() > dt2.getTime()) {
                return 1;
            }
            if (dt1.getTime() < dt2.getTime()) {
                return -1;
            }
            return 0;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 0;
        }
    }

    public static Date str2date(String date) {
        return CommonUtil.str2date(date, "yyyy-MM-dd HH:mm");
    }

    public static Date str2date(String date, String format) {
        SimpleDateFormat df = new SimpleDateFormat(format);
        try {
            return df.parse(date);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static int str2int(String strlong, int def) {
        try {
            if (StringUtils.isNotEmpty((String)strlong)) {
                return Integer.parseInt(strlong);
            }
            return def;
        }
        catch (Exception e) {
            return def;
        }
    }

    public static Long date2diff(Date sd, Date ed) {
        Long s = sd.getTime();
        Long e = ed.getTime();
        if (s > e) {
            Long tmp = s;
            s = e;
            e = tmp;
        }
        return e - s;
    }

    public static int getYear() {
        Calendar cal = Calendar.getInstance();
        int year = cal.get(1);
        String endTime = null;
        endTime = String.valueOf(year) + "-09-01";
        int c = CommonUtil.compare_date(endTime);
        if (c < 0) {
            --year;
        }
        return year;
    }

    public static int compare_date(String date) {
        return CommonUtil.compare_date(date, CommonUtil.dateformat(new Date(), "yyyy-MM-dd"));
    }

    public static int compare_date(Date d1, Date d2) {
        try {
            if (d1.getTime() > d2.getTime()) {
                System.out.println("dt1 \u5728dt2\u524d");
                return 1;
            }
            if (d1.getTime() < d2.getTime()) {
                System.out.println("dt1\u5728dt2\u540e");
                return -1;
            }
            return 0;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 0;
        }
    }

    public static String Date2String(Date date) {
        if (date == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        long millTime = System.currentTimeMillis() - date.getTime();
        long second = millTime / 1000L;
        long minutes = second / 60L;
        long hours = minutes / 60L;
        if (second < 60L) {
            buffer.append(second).append("\u79d2\u524d");
        } else if (minutes < 60L) {
            buffer.append(minutes).append("\u5206\u949f\u524d");
        } else if (hours < 24L) {
            buffer.append(hours).append("\u5c0f\u65f6\u524d");
        } else {
            buffer.append(new SimpleDateFormat("yyyy-MM-dd HH:mm").format(date));
        }
        return buffer.toString();
    }

    public static int compare_date(Date d1) {
        return CommonUtil.compare_date(d1, new Date());
    }

    public static long getInt1tomaxRandom(long max) {
        return Math.round(Math.random() * (double)(max - 10L) + 8.0);
    }

    public static List<String> getHtmlImages(String html) {
        String img = "";
        ArrayList<String> pics = new ArrayList<String>();
        String regEx_img = "<img.*src=(.*?)[^>]*?>";
        Pattern p_image = Pattern.compile(regEx_img, 2);
        Matcher m_image = p_image.matcher(html);
        while (m_image.find()) {
            img = img + "," + m_image.group();
            Matcher m = Pattern.compile("src=\"?(.*?)(\"|>|\\s+)").matcher(img);
            while (m.find()) {
                String url = m.group(1);
                url = url.replace("'", "");
                pics.add(url);
            }
        }
        return pics;
    }

    public static String getTextLen(String text, int len) {
        if (text == null || "".equals(text)) {
            return "";
        }
        text = text.replaceAll("\\&[a-zA-Z]{1,10};", "").replaceAll("<[^>]*>", "");
        if ((text = text.replaceAll("[(/>)<]", "")).length() >= len) {
            return text.substring(0, len - 1) + "...";
        }
        return text;
    }

    public static String delHTMLTag(String htmlStr) {
        String regEx_script = "<script[^>]*?>[\\s\\S]*?<\\/script>";
        String regEx_style = "<style[^>]*?>[\\s\\S]*?<\\/style>";
        String regEx_html = "<[^>]+>";
        Pattern p_script = Pattern.compile(regEx_script, 2);
        Matcher m_script = p_script.matcher(htmlStr);
        htmlStr = m_script.replaceAll("");
        Pattern p_style = Pattern.compile(regEx_style, 2);
        Matcher m_style = p_style.matcher(htmlStr);
        htmlStr = m_style.replaceAll("");
        Pattern p_html = Pattern.compile(regEx_html, 2);
        Matcher m_html = p_html.matcher(htmlStr);
        htmlStr = m_html.replaceAll("");
        return htmlStr.trim();
    }

    public static String local2url(String filePath, String firstIndex) {
        String webfilepath = "/" + filePath.substring(filePath.indexOf(firstIndex), filePath.length());
        try {
            webfilepath = webfilepath.replaceAll("\\\\", "/");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return webfilepath;
    }

    public static String str2Sort(String sort) {
        if (sort == null || "".equals(sort.trim())) {
            return sort;
        }
        Object[] ary = sort.split(",");
        Arrays.sort(ary);
        return StringUtils.join((Object[])ary, (String)",");
    }

    public static String str2Sort2(String sort) {
        if (sort == null || "".equals(sort.trim())) {
            return sort;
        }
        sort = sort.replaceAll("\\[", "").replaceAll("\\]", ",");
        Object[] ary = sort.split(",");
        Arrays.sort(ary);
        return StringUtils.join((Object[])ary, (String)",");
    }

    public static String ary2str(String sort, String replacement) {
        if (sort == null || "".equals(sort.trim())) {
            return sort;
        }
        Object[] ary = sort.split(",");
        Arrays.sort(ary);
        StringBuffer result = new StringBuffer();
        for (Object item : ary) {
            if ("[]".equals(replacement)) {
                result.append("[").append((String)item).append("]");
                continue;
            }
            if ("{}".equals(replacement)) {
                result.append("{").append((String)item).append("}");
                continue;
            }
            if ("()".equals(replacement)) {
                result.append("(").append((String)item).append(")");
                continue;
            }
            if ("<>".equals(replacement)) {
                result.append("<").append((String)item).append(">");
                continue;
            }
            result.append((String)item).append(replacement);
        }
        return result.toString();
    }

    public static String getWeiboTime(Date date) {
        if (date == null) {
            return "";
        }
        Calendar cal = Calendar.getInstance();
        int year = cal.get(1);
        int dateYear = Integer.parseInt(new SimpleDateFormat("yyyy").format(date));
        StringBuffer buffer = new StringBuffer();
        long millTime = System.currentTimeMillis() - date.getTime();
        long second = millTime / 1000L;
        long minutes = second / 60L;
        long hours = minutes / 60L;
        if (second < 60L) {
            buffer.append("\u521a\u521a");
        } else if (minutes < 60L) {
            buffer.append(minutes).append("\u5206\u949f\u524d");
        } else if (hours < 24L) {
            buffer.append(hours).append("\u5c0f\u65f6\u524d");
        } else if (dateYear != year) {
            buffer.append(new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5 HH:mm").format(date));
        } else {
            buffer.append(new SimpleDateFormat("MM\u6708dd\u65e5 HH:mm").format(date));
        }
        return buffer.toString();
    }

    public static boolean getTypeContains(String contentType, String type) {
        return contentType.contains(type);
    }

    public static String[] removeRepeat(String[] arry) {
        List<String> strList = Arrays.asList(arry);
        HashSet<String> strSet = new HashSet<String>(strList);
        String[] newArray = new String[strSet.size()];
        Iterator ite = strSet.iterator();
        int i = 0;
        while (ite.hasNext()) {
            newArray[i] = (String)ite.next();
            ++i;
        }
        return newArray;
    }

    public static String[] getShortUrlArray(String str) {
        String[] s = new String[]{};
        if (str.contains("http://v.cn/") && str.contains(" ")) {
            String[] strArray = str.split(" ");
            ArrayList<String> strList = new ArrayList<String>();
            for (int i = 0; i < strArray.length; ++i) {
                String a = strArray[i];
                if (!strArray[i].contains("http://v.cn/")) continue;
                String sUrl = a.substring(a.lastIndexOf("http://v.cn/"), a.length()) + " ";
                strList.add(sUrl);
            }
            HashSet strSet = new HashSet(strList);
            String[] newArray = new String[strSet.size()];
            Iterator ite = strSet.iterator();
            int i = 0;
            while (ite.hasNext()) {
                newArray[i] = (String)ite.next();
                ++i;
            }
            return newArray;
        }
        return s;
    }

    public static Object convertorBean(Object T, Object T1) {
        try {
            BeanUtils.copyProperties((Object)T, (Object)T1);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return T;
    }

    public static String createLink(String domain, String urlString) {
        boolean isMatch;
        if (urlString == null || "".equals(urlString)) {
            return "";
        }
        boolean bl = isMatch = urlString != null && (urlString.indexOf("http://") >= 0 || urlString.indexOf("https://") >= 0);
        if (!urlString.substring(0, 1).equals("/")) {
            domain = domain + "/";
        }
        if (!isMatch) {
            return domain + urlString;
        }
        return urlString;
    }

    public static String createLink(String domain, String urlString, String params) {
        if (urlString == null || "".equals(urlString)) {
            return "";
        }
        boolean isMatch = urlString != null && (urlString.indexOf("http://") >= 0 || urlString.indexOf("https://") >= 0);
        String url = urlString == null ? "" : urlString;
        System.out.println("urlString substring 0-1:=" + url.substring(0, 1));
        if (!url.substring(0, 1).equals("/")) {
            domain = domain + "/";
        }
        if (!isMatch) {
            url = domain + url;
        }
        url = url.indexOf("?") >= 0 ? url + "&" + params : url + "?" + params;
        url = url + params;
        return url;
    }

    public static HttpServletResponse download(String filePath, HttpServletResponse response) {
        try {
            File file = new File(filePath);
            String filename = file.getName();
            String ext = filename.substring(filename.lastIndexOf(".") + 1).toUpperCase();
            if (filePath.indexOf("\\.\\") > 0) {
                filePath = filePath.replace("/./", "/");
            }
            BufferedInputStream fis = new BufferedInputStream(new FileInputStream(filePath));
            byte[] buffer = new byte[((InputStream)fis).available()];
            ((InputStream)fis).read(buffer);
            ((InputStream)fis).close();
            response.reset();
            response.addHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(new String(filename.getBytes()), "utf-8"));
            response.addHeader("Content-Length", "" + file.length());
            BufferedOutputStream toClient = new BufferedOutputStream((OutputStream)response.getOutputStream());
            response.setContentType("application/octet-stream");
            ((OutputStream)toClient).write(buffer);
            ((OutputStream)toClient).flush();
            ((OutputStream)toClient).close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return response;
    }

    public static File saveMultipartFile(MultipartFile file, String path) throws Exception {
        String fileName = "tmp_" + String.valueOf(System.currentTimeMillis());
        String fileSuffix = file.getOriginalFilename().substring(file.getOriginalFilename().lastIndexOf("."));
        String weiboPath = File.separator + "upload" + File.separator + path + File.separator + CommonUtil.dateformat(new Date(), "yyyyMMdd") + File.separator;
        String uploadRealPath = EnvProperUtil.webrealpath + weiboPath + fileName + fileSuffix;
        File realPath = new File(uploadRealPath);
        try {
            realPath.mkdirs();
        }
        catch (Exception e) {
            // empty catch block
        }
        file.transferTo(realPath);
        return realPath;
    }

    public static void main(String[] args) {
        System.out.println(CommonUtil.delHTMLTag("\u613f\u8d60\u4e8e\u5b83\u4e00\u5bf9\u5b8c\u6574\u7684\u7fc5\u8180<img src='http://wei.linkbo.net//upload/wishes/1405017822909thumb.jpg' style='width:198px; height:auto;'></img>"));
    }
}

