/*
 * Decompiled with CFR 0.152.
 */
package edu.minilive.wedu.service.impl;

import edu.ecompus.core.entity.Page;
import edu.ecompus.core.service.GenerateService;
import edu.minilive.wedu.dao.WeiVideoConfigDAO;
import edu.minilive.wedu.dao.WeiVideoDAO;
import edu.minilive.wedu.entity.Company;
import edu.minilive.wedu.entity.User;
import edu.minilive.wedu.entity.app.WeiVideo;
import edu.minilive.wedu.entity.app.WeiVideoConfig;
import edu.minilive.wedu.service.WeiVideoService;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service(value="weivideoService")
public class WeiVideoServiceImpl
extends GenerateService
implements WeiVideoService {
    @Autowired
    WeiVideoDAO weiVideoDAO;
    @Autowired
    WeiVideoConfigDAO weiVideoConfigDAO;

    @Override
    @Cacheable(value={"default"}, key="'WeiVideo-cache-by' + #id")
    public WeiVideo getWeiVideoById(Long id) {
        return (WeiVideo)this.weiVideoDAO.query(id);
    }

    @Override
    public WeiVideo createWeiVideo(WeiVideo weiVideo) {
        this.weiVideoDAO.create(weiVideo);
        return weiVideo;
    }

    @Override
    @CacheEvict(value={"default"}, key="'WeiVideo-cache-by' + #weiVideo.id")
    public void updateWeiVideo(WeiVideo weiVideo) {
        this.weiVideoDAO.update(weiVideo);
    }

    @Override
    @CacheEvict(value={"default"}, key="'WeiVideo-cache-by' + #weiVideo.id")
    public void deleteWeiVideo(WeiVideo weiVideo) {
        this.weiVideoDAO.delete(weiVideo);
    }

    @Override
    @Cacheable(value={"default"}, key="'WeiVideoList-cache-byCompany' + #company.id")
    public List<WeiVideo> getCompanyVideo(Company company, Page page) {
        if (company != null) {
            return this.weiVideoDAO.queryCompanyVideo(company, page);
        }
        return Collections.emptyList();
    }

    @Override
    @CacheEvict(value={"default"}, key="'WeiVideo-cache-by' + #videoId")
    public void updateVideoStatus(Long videoId, int status) {
        this.weiVideoDAO.updateVideoStatus(videoId, status);
    }

    @Override
    public List<WeiVideo> getVideoList(String title, int status, User user, Company company, int subject, Page page) {
        return this.weiVideoDAO.queryVideoList(title, status, user, company, subject, page);
    }

    @Override
    @Cacheable(value={"default"}, key="'WeiVideoConfig-cache-by' + #company.id")
    public WeiVideoConfig getWeiVideoConfigByCompany(Company company) {
        if (company != null) {
            return this.weiVideoConfigDAO.queryWeiVideoConfigByCompany(company);
        }
        return null;
    }

    @Override
    public WeiVideoConfig createWeiVideoConfig(WeiVideoConfig weiVideoConfig) {
        this.weiVideoConfigDAO.create(weiVideoConfig);
        return weiVideoConfig;
    }

    @Override
    public void updateWeiVideoConfig(WeiVideoConfig weiVideoConfig) {
        this.weiVideoConfigDAO.update(weiVideoConfig);
    }

    @Override
    public void deleteWeiVideoConfig(WeiVideoConfig weiVideoConfig) {
        this.weiVideoConfigDAO.delete(weiVideoConfig);
    }
}

