/*
 * Decompiled with CFR 0.152.
 */
package edu.minilive.wedu.service.impl;

import edu.ecompus.core.entity.Page;
import edu.ecompus.core.service.GenerateService;
import edu.minilive.wedu.dao.WeiPhotoDAO;
import edu.minilive.wedu.entity.Company;
import edu.minilive.wedu.entity.app.WeiAlbum;
import edu.minilive.wedu.entity.app.WeiPhoto;
import edu.minilive.wedu.service.WeiPhotoService;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service(value="weiphotoService")
public class WeiPhotoServiceImpl
extends GenerateService
implements WeiPhotoService {
    @Autowired
    WeiPhotoDAO photoDAO;

    @Override
    @Cacheable(value={"default"}, key="'Photo-cache-by' + #id")
    public WeiPhoto getPhotoById(Long id) {
        return (WeiPhoto)this.photoDAO.query(id);
    }

    @Override
    public WeiPhoto addWeiPhoto(WeiPhoto weiPhoto) {
        this.photoDAO.create(weiPhoto);
        return weiPhoto;
    }

    @Override
    @CacheEvict(value={"default"}, key="'Photo-cache-by' + #weiPhoto.id")
    public void editWeiPhoto(WeiPhoto weiPhoto) {
        this.photoDAO.update(weiPhoto);
    }

    @Override
    public List<WeiPhoto> getPhotoListByToken(String token, Company company, Page page) {
        return this.photoDAO.queryPhotoListByToken(token, company, page);
    }

    @Override
    public List<WeiPhoto> getPhotoListByCompany(String title, Company company, WeiAlbum weiAlbum, Page page) {
        if (company == null && weiAlbum == null) {
            return Collections.emptyList();
        }
        return this.photoDAO.queryPhotoListByCompany(title, company, weiAlbum, page);
    }

    @Override
    public List<WeiPhoto> getPhotoListByIds(String photoIds, Company company, WeiAlbum weiAlbum, Page page) {
        return this.photoDAO.queryPhotoListByIds(photoIds, company, weiAlbum, page);
    }

    @Override
    public Long countAlbumPhoto(WeiAlbum weiAlbum) {
        return this.photoDAO.countAlbumPhoto(weiAlbum);
    }
}

