/*
 * Decompiled with CFR 0.152.
 */
package edu.minilive.wedu.service.impl;

import edu.ecompus.core.service.GenerateService;
import edu.minilive.wedu.dao.DistrictDAO;
import edu.minilive.wedu.entity.District;
import edu.minilive.wedu.service.DistrictService;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service(value="distictService")
public class DistrictServiceImpl
extends GenerateService
implements DistrictService {
    @Autowired
    DistrictDAO districtDAO;

    @Override
    public District addDistrict(District district) {
        this.districtDAO.create(district);
        return district;
    }

    @Override
    public void updateDistrict(District district) {
        this.districtDAO.update(district);
    }

    @Override
    public void delDistrict(District district) {
        this.districtDAO.delete(district);
    }

    @Override
    @Cacheable(value={"default"}, key="'district-cache-by' + #id")
    public District getDistrictById(Long id) {
        return (District)this.districtDAO.query(id);
    }

    @Override
    @Cacheable(value={"default"}, key="'district-provincelist'")
    public List<District> getAllProvince() {
        return this.districtDAO.queryAllProvince();
    }

    @Override
    @Cacheable(value={"default"}, key="'district-citylist-p' + #provinceId ")
    public List<District> getCityList(Long provinceId) {
        return this.districtDAO.queryCityList(provinceId);
    }

    @Override
    public List<District> getDistrictListByIds(String ids) {
        return this.districtDAO.queryDistrictListByIds(ids);
    }

    @Override
    @Cacheable(value={"default"}, key="'district-arealist-c' + #cityId ")
    public List<District> getAreaList(Long cityId) {
        return this.districtDAO.queryAreaList(cityId);
    }

    @Override
    public List<District> getFuzzy(String name, int level) {
        if (name != null && !"".equals(name)) {
            return this.districtDAO.queryFuzzy(name, level);
        }
        return Collections.emptyList();
    }

    @Override
    public District getDistrictFuzzy(String name, int level) {
        List<District> list = this.getFuzzy(name, level);
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }
}

