/*
 * Decompiled with CFR 0.152.
 */
package edu.minilive.wedu.service.impl;

import edu.ecompus.core.entity.Page;
import edu.ecompus.core.service.GenerateService;
import edu.minilive.wedu.dao.CustomMenuDAO;
import edu.minilive.wedu.entity.Company;
import edu.minilive.wedu.entity.CustomMenu;
import edu.minilive.wedu.service.CustomMenuService;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service(value="custommenuService")
public class CustomMenuServiceImpl
extends GenerateService
implements CustomMenuService {
    @Autowired
    CustomMenuDAO customMenuDAO;

    @Override
    public CustomMenu addCustomMenu(CustomMenu customMenu) {
        this.customMenuDAO.create(customMenu);
        return customMenu;
    }

    @Override
    @Cacheable(value={"default"}, key="'CustomMenu-cache-by' + #id")
    public CustomMenu getCustomMenuById(Long id) {
        return (CustomMenu)this.customMenuDAO.query(id);
    }

    @Override
    @CacheEvict(value={"default"}, key="'CustomMenu-cache-by' + #customMenu.id")
    public CustomMenu updateCustomMenu(CustomMenu customMenu) {
        this.customMenuDAO.update(customMenu);
        return customMenu;
    }

    @Override
    public List<CustomMenu> getCustomMenuListByCompanyId(Company school, int level) {
        if (school == null) {
            return Collections.emptyList();
        }
        return this.customMenuDAO.queryCustomMenuListByCompanyId(school.getId(), level);
    }

    @Override
    @Cacheable(value={"default"}, key="'CustomMenu-cache-by-eventKey-' + #eventKey")
    public CustomMenu getCustomMenuByEventKey(String eventKey) {
        if (eventKey == null || "".equals(eventKey)) {
            return null;
        }
        List<CustomMenu> list = this.customMenuDAO.queryCustomMenuByEventKey(eventKey, new Page(1, 1));
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }
}

