/*
 * Decompiled with CFR 0.152.
 */
package edu.minilive.wedu.service.impl;

import edu.ecompus.core.entity.Page;
import edu.ecompus.core.service.GenerateService;
import edu.minilive.wedu.dao.CompanyDAO;
import edu.minilive.wedu.entity.Company;
import edu.minilive.wedu.entity.District;
import edu.minilive.wedu.service.CompanyService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service(value="companyService")
public class CompanyServiceImpl
extends GenerateService
implements CompanyService {
    @Autowired
    private CompanyDAO companyDAO;

    @Override
    public List<Company> getCompanyList() {
        return this.companyDAO.queryCompanyList();
    }

    @Override
    public void creatCompany(Company company) {
        if (company != null) {
            this.companyDAO.create(company);
        }
    }

    @Override
    @Cacheable(value={"default"}, key="'company-cache-by' + #companyId")
    public Company getCompany(Long companyId) {
        if (companyId != null && companyId > 0L) {
            return (Company)this.companyDAO.query(companyId);
        }
        return null;
    }

    @Override
    public void updateCompany(Company company) {
        if (company != null) {
            this.companyDAO.update(company);
        }
    }

    @Override
    public List<Company> getCompanyListByKey(String companyName, int status, Long provinceId, Long cityId, Long areaId) {
        return this.companyDAO.queryCompanyListByKey(companyName, status, provinceId, cityId, areaId);
    }

    @Override
    public Company getCompanyByName(String companyName, Long provinceId, Long cityId, Long areaId) {
        List<Company> list;
        if (companyName != null && !"".equals(companyName) && (list = this.getCompanyListByKey(companyName, 1, provinceId, cityId, areaId)).size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public List<Company> getCompanyListBySystem(String keyword, int type, int subtype, int status, District province, District city, int vertystate, Page page) {
        return this.companyDAO.queryCompanyListBySystem(keyword, type, subtype, status, province, city, vertystate, page);
    }
}

