/*
 * Decompiled with CFR 0.152.
 */
package edu.minilive.wedu.service.impl;

import edu.ecompus.core.entity.Page;
import edu.ecompus.core.service.GenerateService;
import edu.minilive.wedu.dao.ChannelDAO;
import edu.minilive.wedu.entity.Channel;
import edu.minilive.wedu.entity.Company;
import edu.minilive.wedu.service.ChannelService;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service(value="channelService")
public class ChannelServiceImpl
extends GenerateService
implements ChannelService {
    @Autowired
    ChannelDAO channelDAO;

    @Override
    public Channel addChannel(Channel post) {
        if (post != null) {
            this.channelDAO.create(post);
        }
        return post;
    }

    @Override
    @Cacheable(value={"default"}, key="'channel-cache-by' + #id")
    public Channel getChannelById(Long id) {
        return (Channel)this.channelDAO.query(id);
    }

    @Override
    @Cacheable(value={"default"}, key="'channel-cache-byalias' + #id")
    public Channel getChannelByAlias(String alias) {
        return this.channelDAO.queryChannelByAlias(alias);
    }

    @Override
    @CacheEvict(value={"default"}, key="'channel-cache-by' + #channel.id")
    public Channel updateChannel(Channel channel) {
        this.channelDAO.update(channel);
        return channel;
    }

    @Override
    @Cacheable(value={"default"}, key="'channel-cache-byparent' + #id")
    public List<Channel> getChannelListByParent(Channel channel) {
        if (channel == null) {
            return Collections.emptyList();
        }
        return this.channelDAO.queryChannelListByParent(channel);
    }

    @Override
    @CacheEvict(value={"default"}, key="'channel-cache-byparent' + #channel.id")
    public void clearChannelListByParentCache(Channel channel) {
    }

    @Override
    @Cacheable(value={"default"}, key="'firstchannel-cache'")
    public List<Channel> getChannelList() {
        return this.channelDAO.queryChannelList();
    }

    @Override
    public List<Channel> getChannelByCompany(Company company, Channel parentChannel, Page page) {
        return this.channelDAO.queryChannelByCompany(company, parentChannel, page);
    }
}

