/*
 * Decompiled with CFR 0.152.
 */
package edu.minilive.wedu.service.impl;

import edu.ecompus.core.entity.Page;
import edu.ecompus.core.service.GenerateService;
import edu.minilive.wedu.dao.AutoRespondDAO;
import edu.minilive.wedu.entity.AutoRespond;
import edu.minilive.wedu.entity.Company;
import edu.minilive.wedu.service.AutoRespondService;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service(value="autorespondService")
public class AutoRespondServiceImpl
extends GenerateService
implements AutoRespondService {
    @Autowired
    AutoRespondDAO autoRespondDAO;

    @Override
    public AutoRespond addAutoRespond(AutoRespond autoRespond) {
        if (autoRespond != null) {
            this.autoRespondDAO.create(autoRespond);
        }
        return autoRespond;
    }

    @Override
    @Cacheable(value={"default"}, key="'AutoRespond-cache-by' + #id")
    public AutoRespond getAutoRespondById(Long id) {
        return (AutoRespond)this.autoRespondDAO.query(id);
    }

    @Override
    @CacheEvict(value={"default"}, key="'AutoRespond-cache-by' + #autoRespond.id")
    public AutoRespond updateAutoRespond(AutoRespond autoRespond) {
        this.autoRespondDAO.update(autoRespond);
        return autoRespond;
    }

    @Override
    public List<AutoRespond> getAutoRespondListByCompany(Company school, Page page) {
        if (school == null) {
            return Collections.emptyList();
        }
        return this.autoRespondDAO.queryAutoRespondListByCompany(school.getId(), page);
    }

    @Override
    public List<AutoRespond> getAutoRespondListByType(Company school, int type, Page page) {
        if (school == null) {
            return Collections.emptyList();
        }
        return this.autoRespondDAO.queryAutoRespondListByType(school.getId(), type, page);
    }

    @Override
    public AutoRespond getAutoRespondByClickKey(Company school, String keyId) {
        if (school == null || keyId == null || "".equals(keyId)) {
            return null;
        }
        List<AutoRespond> list = this.autoRespondDAO.queryAutoRespondByClickKeyLike(school.getId(), keyId, new Page(1, 1));
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }
}

