/*
 * Decompiled with CFR 0.152.
 */
package edu.minilive.wedu.service.impl;

import edu.ecompus.core.entity.Page;
import edu.ecompus.core.service.GenerateService;
import edu.minilive.wedu.dao.ArticleDAO;
import edu.minilive.wedu.entity.Article;
import edu.minilive.wedu.entity.User;
import edu.minilive.wedu.service.ArticleService;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service(value="articleService")
public class ArticleServiceImpl
extends GenerateService
implements ArticleService {
    @Autowired
    ArticleDAO articleDAO;

    @Override
    public Article addArticle(Article article) {
        this.articleDAO.create(article);
        return article;
    }

    @Override
    @Cacheable(value={"default"}, key="'article-cache-by' + #id")
    public Article getArticleById(Long id) {
        return (Article)this.articleDAO.query(id);
    }

    @Override
    @CacheEvict(value={"default"}, key="'article-cache-by' + #article.id")
    public Article updateArticle(Article article) {
        this.articleDAO.update(article);
        return article;
    }

    @Override
    public List<Article> getChannelList(Long channelId, Page page) {
        return this.articleDAO.queryChannelList(channelId, page);
    }

    @Override
    public List<Article> getArticleByUser(User user, Page page) {
        return this.articleDAO.queryArticleByUser(user, page);
    }

    @Override
    public List<Article> getArticleByKeyword(String keyword, Page page) {
        return this.articleDAO.queryArticleByKeyword(keyword, page);
    }

    @Override
    public List<Article> getArticleByTag(String tag, Page page) {
        return this.articleDAO.queryArticleByTag(tag, page);
    }

    @Override
    public List<Article> getArticleListByCompany(Long companyId, String keyword, Long channelId, Page page) {
        if (companyId == null || companyId <= 0L) {
            return Collections.emptyList();
        }
        return this.articleDAO.queryArticleListByCompany(companyId, keyword, channelId, page);
    }
}

