/*
 * Decompiled with CFR 0.152.
 */
package edu.minilive.wedu.entity;

import edu.ecompus.core.util.HttpUtil;
import edu.minilive.wedu.entity.Channel;
import edu.minilive.wedu.entity.Company;
import edu.minilive.wedu.entity.User;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@Table(name="TAB_ARTICLE")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class Article {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id = 0L;
    private String title;
    private String subtitle;
    private String text;
    private String tags;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="channel_id")
    private Channel channel;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="user_id")
    private User user;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="school_id")
    private Company school;
    private int state = 1;
    private Date createDate;
    private Long clickCount = 0L;

    @Transient
    public String getTextImg() {
        if (this.text != null && !"".equals(this.text)) {
            String img = "";
            String regEx_img = "<img.*src=(.*?)[^>]*?>";
            Pattern p_image = Pattern.compile(regEx_img, 2);
            Matcher m_image = p_image.matcher(HttpUtil.encodeHtml((String)this.text));
            while (m_image.find()) {
                img = img + "," + m_image.group();
                Matcher m = Pattern.compile("src=\"?(.*?)(\"|>|\\s+)").matcher(img);
                if (!m.find()) continue;
                String url = m.group(1);
                url = url.replace("'", "");
                return url;
            }
        }
        return "";
    }

    public Long getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public String getSubtitle() {
        return this.subtitle;
    }

    public String getText() {
        return this.text;
    }

    public String getTags() {
        return this.tags;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public User getUser() {
        return this.user;
    }

    public Company getSchool() {
        return this.school;
    }

    public int getState() {
        return this.state;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public Long getClickCount() {
        return this.clickCount;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setSubtitle(String subtitle) {
        this.subtitle = subtitle;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setTags(String tags) {
        this.tags = tags;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void setSchool(Company school) {
        this.school = school;
    }

    public void setState(int state) {
        this.state = state;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public void setClickCount(Long clickCount) {
        this.clickCount = clickCount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Article)) {
            return false;
        }
        Article other = (Article)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$subtitle = this.getSubtitle();
        String other$subtitle = other.getSubtitle();
        if (this$subtitle == null ? other$subtitle != null : !this$subtitle.equals(other$subtitle)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        String this$tags = this.getTags();
        String other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !this$tags.equals(other$tags)) {
            return false;
        }
        Channel this$channel = this.getChannel();
        Channel other$channel = other.getChannel();
        if (this$channel == null ? other$channel != null : !((Object)this$channel).equals(other$channel)) {
            return false;
        }
        User this$user = this.getUser();
        User other$user = other.getUser();
        if (this$user == null ? other$user != null : !((Object)this$user).equals(other$user)) {
            return false;
        }
        Company this$school = this.getSchool();
        Company other$school = other.getSchool();
        if (this$school == null ? other$school != null : !((Object)this$school).equals(other$school)) {
            return false;
        }
        if (this.getState() != other.getState()) {
            return false;
        }
        Date this$createDate = this.getCreateDate();
        Date other$createDate = other.getCreateDate();
        if (this$createDate == null ? other$createDate != null : !((Object)this$createDate).equals(other$createDate)) {
            return false;
        }
        Long this$clickCount = this.getClickCount();
        Long other$clickCount = other.getClickCount();
        return !(this$clickCount == null ? other$clickCount != null : !((Object)this$clickCount).equals(other$clickCount));
    }

    public boolean canEqual(Object other) {
        return other instanceof Article;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        Long $id = this.getId();
        result = result * 31 + ($id == null ? 0 : ((Object)$id).hashCode());
        String $title = this.getTitle();
        result = result * 31 + ($title == null ? 0 : $title.hashCode());
        String $subtitle = this.getSubtitle();
        result = result * 31 + ($subtitle == null ? 0 : $subtitle.hashCode());
        String $text = this.getText();
        result = result * 31 + ($text == null ? 0 : $text.hashCode());
        String $tags = this.getTags();
        result = result * 31 + ($tags == null ? 0 : $tags.hashCode());
        Channel $channel = this.getChannel();
        result = result * 31 + ($channel == null ? 0 : ((Object)$channel).hashCode());
        User $user = this.getUser();
        result = result * 31 + ($user == null ? 0 : ((Object)$user).hashCode());
        Company $school = this.getSchool();
        result = result * 31 + ($school == null ? 0 : ((Object)$school).hashCode());
        result = result * 31 + this.getState();
        Date $createDate = this.getCreateDate();
        result = result * 31 + ($createDate == null ? 0 : ((Object)$createDate).hashCode());
        Long $clickCount = this.getClickCount();
        result = result * 31 + ($clickCount == null ? 0 : ((Object)$clickCount).hashCode());
        return result;
    }

    public String toString() {
        return "Article(id=" + this.getId() + ", title=" + this.getTitle() + ", subtitle=" + this.getSubtitle() + ", text=" + this.getText() + ", tags=" + this.getTags() + ", channel=" + this.getChannel() + ", user=" + this.getUser() + ", school=" + this.getSchool() + ", state=" + this.getState() + ", createDate=" + this.getCreateDate() + ", clickCount=" + this.getClickCount() + ")";
    }
}

