package edu.minilive.wedu.util;

import java.util.List;


import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.AntPathMatcher;


/**
 * 权限验证工具类
 * 
 * 
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-1-15 下午3:35:38
 */
public final class PermitMatcherUtil {
	/***
	 * 日志
	 */
	private static final Logger logger = LoggerFactory.getLogger(PermitMatcherUtil.class);
			
	/**
	 * 正则工具
	 */
	private static AntPathMatcher urlMatcher = new AntPathMatcher();
	
	/**
	 * 判断当前登录用户是否有权限
	 * @param req
	 * @return
	 */
	public static boolean hasPrivilege(List<String> permitlist, String requestUrl){
		//TODO 验证当前用户以及当前访问的Url地址权限
		if(requestUrl==null || "".equals(requestUrl)){
			return false;
		}
		
		if(requestUrl.indexOf("?")!=-1) {
    		requestUrl = requestUrl.substring(0, requestUrl.indexOf("?"));
    	}
		//获取父url--如果不是直接输入的话就是先前的访问过来的页面，要是用户输入了，这个父url是不存在的
		//String referer = req.getHeader("REFERER");
		//String gotoPage=req.getContextPath()+url;
		
		//是否存在权限
		boolean match = false;
		//TODO 遍历判断用户权限
		for(String permitUrl : permitlist){
			if(permitUrl!=null && !StringUtils.isEmpty(permitUrl)){
				match = urlMatcher.match(permitUrl, requestUrl);
				if(logger.isInfoEnabled()){
					logger.info(String.format("权限[%s]--[%s]=%s",permitUrl, requestUrl, match));
				}
				if(match){	//验证true,表示有权限,若是false,继续遍历
					return true;
				}
			}
		}
		
		//TODO  测试时设置为True,表示都有权限,发布时设置为False,严格控制权限
		return match;
	}
}
