package edu.minilive.wedu.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.servlet.http.HttpServletResponse;


import edu.ecompus.core.util.EnvProperUtil;
import edu.ecompus.core.util.FileUtil;

import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.web.multipart.MultipartFile;

import com.google.gson.Gson;

/**
 * 通用工具类
 * 
 * 
 * CopyRright (c) 2013: <紫悦新橙> Project: <数字化校园 > Module ID:
 * <(模块)类编号，可以引用系统设计中的类编号> Comments: <对此类的描述，可以引用系统设计中的描述> JDK version used:
 * <JDK1.6>
 * 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2013-8-20 上午9:59:24
 */
public class CommonUtil {
	private static Gson gson = new Gson();
	
	private static String[] units = new String[] { "零", "一", "二", "三", "四",	"五", "六", "七", "八", "九", "十" };
	/**
	 * 星期中文字符
	 */
	private static String[] weeks = new String[] { "一", "二", "三", "四", "五",	"六", "日" };

	
	/**
	 * 将对象转换为json格式
	 * 
	 * @param object
	 * @return
	 */
	public static String object2json(Object object) {
		return gson.toJson(object);
	}

	/**
	 * 转换code与message为json格式
	 * 
	 * @param code
	 * @param message
	 * @return
	 */
	public static String codemessage2json(String code, String message) {
		Map<String, String> map = new HashMap<String, String>();

		map.put("code", code);
		map.put("msg", message);

		return getJsonResult(map);
	}

	/**
	 * 转换为JSON
	 * 
	 * @param map
	 * @return
	 */
	public static String getJsonResult(Map<String, String> map) {
		return gson.toJson(map);
	}

	/**
	 * 转换code与json message为json格式返回
	 * 
	 * @param code
	 * @param jsondata
	 * @return
	 */
	public static String code2json(String code, Map<String, String> jsondata) {
		Map<String, String> map = new HashMap<String, String>();
		map.put("code", code);
		map.put("json", gson.toJson(jsondata));

		return gson.toJson(map);
	}

	/**
	 * 
	 * @param code
	 * @param list
	 * @return
	 */
	public static String code2jlist(String code, List list) {
		Map<String, String> map = new HashMap<String, String>();
		map.put("code", code);
		map.put("list", gson.toJson(list));

		return gson.toJson(map);
	}

	/**
	 * 转换code与message为json格式
	 * 
	 * @param code
	 * @param message
	 * @return
	 */
	public static String code2json(String code, String message) {
		Map<String, String> map = new HashMap<String, String>();

		map.put("code", code);
		map.put("msg", message);

		return gson.toJson(map);
	}
	
	/**
	 * 将SO转换为JSON格式
	 * @param code			
	 * @param objctName		返回数据名
	 * @param objct			数据对象
	 * @return
	 */
	public static String code2data(String code, String objctName, Object objct) {
		Map<String, String> map = new HashMap<String, String>();
		map.put("code", code);
		if(objctName==null || !"".equals(objctName)) {
			objctName = "data";
		}
		map.put(objctName, gson.toJson(objct));

		return gson.toJson(map);
	}
	
	
	/**
	 * 点击>>文本
	 * 
	 * @param clickNum
	 * @return
	 */
	public static String clickNum2Text(long clickNum) {
		NumberFormat formater = new DecimalFormat("###,###");

		return formater.format(clickNum);
	}



	/**
	 * 将10以内的数字转换为中文数字
	 * 
	 * @param num
	 * @return
	 */
	public static String int2ChineseNum(int num) {
		if (num > 11) {
			return String.valueOf(num);
		}

		return units[num];
	}

	/**
	 * 将字符型转换为数字型,异常则返回0
	 * 
	 * @param strlong
	 *            字符型
	 * @return
	 */
	public static long str2long(String strlong) {
		try {
			if ("".equals(strlong.replaceAll(" ", "")))
				return 0;
			else
				return Long.valueOf(strlong);
		} catch (Exception e) {
			return 0;
		}
	}

	/**
	 * 720x576,提取它的高度
	 * 
	 * @param video
	 * @param idx
	 *            0:宽高,高宽
	 * @return
	 */
	public static long getVideoMesh(String video, int idx, Long dv) throws Exception {
		if(StringUtil.isEmpty(video)){
			return dv;
		}
		
		String[] arr = video.split("x");
		if(arr.length>idx){
			Long _value = str2long(arr[idx]);
			if(_value>0){
				return _value;
			}
		}
		
		return dv;
	}

	/**
	 * 播放时长00:24:01.49转换为long弄
	 * 
	 * @param duration
	 * @return
	 */
	public static long Duration2long(String duration) throws Exception {
		long result = 0l;
		String[] arr = duration.split(":");
		// 将小时转换为秒
		result += str2long(arr[0]) * 3600;
		// 将分转换为秒
		result += str2long(arr[1]) * 60;
		// 提取秒
		result += Float.valueOf(arr[arr.length - 1]);

		result = result * 1000;

		return result;
	}

	/**
	 * 播放时长
	 * 
	 * @param Duration
	 *            时长
	 * @return 00:00:00
	 */
	public static String Duration2bit(Long duration) {
		try {
			// 将时长/1000再进行计算
			long ld = duration / 1000;

			// 年份
			// long year = ld/(365*24*3600);
			ld = ld % (365 * 24 * 3600);
			// 月份
			// long month = ld/(30*24*3600);
			ld = ld % (30 * 24 * 3600);
			// 天数
			// long day = ld/(24*3600);
			ld = ld % (24 * 3600);
			// 小时
			long hour = ld / 3600;
			ld = ld % 3600;
			// 分钟
			long min = ld / 60;
			ld = ld % 60;
			// 秒
			long sec = ld;

			// System.out.println(mss+"是："+year+"年"+month+"月"+day+"天"+hour+"小时"+min+"分钟"+sec+"秒");

			String result = "";
			result += (sec >= 10 ? "" : "0") + sec;
			result = (min > 0 ? (min >= 10 ? "" : "0") + min + ":" : "00:")
					+ result;
			result = (hour > 0 ? (hour >= 10 ? "" : "0") + hour + ":" : "")
					+ result;

			return result;
		} catch (Exception e) {
			return "00:00";
		}
	}

	/**
	 * 将音频转换为K
	 * 
	 * @param ahz
	 * @return
	 * @throws Exception
	 */
	public static float getAudioHZ(String ahz) throws Exception {
		float result = Float.valueOf(ahz);

		result /= 1000;

		return result;
	}

	
	/**
	 * 将文件大小转换为MB/KB
	 * 
	 * @param filesize
	 * @return
	 */
	public static String filesize2mb(long filesize) {
		if(filesize>1*1024 && filesize<1*1024*1024){	
			return String.format("%s KB", filesize / 1024); 
		}else if(filesize>=1*1024*1024 && filesize<1*1024*1024){
			return String.format("%s MB", filesize / 1024 / 1024); 
		}
		
		return String.format("%s B", filesize);
	}
	
	/**
	 * 将文件大小转换为MB
	 * 
	 * @param filesize
	 * @return
	 */
	public static Long long2mb(long filesize) {
		return filesize / 1024 / 1024;
	}

	/**
	 * 根据字节转换为KB或者MB
	 * 
	 * @param n
	 *            字节大小
	 * @return
	 */
	public static String b2mb(long filesize) {
		double r = 0.0;
		String sbyte = "";
		if (filesize > (1l * 1024 * 1024 * 1024 * 1024)) {
			sbyte = "T";
			r = Math.round((filesize / 1024 / 1024 / 1024 / 1024) * 10) / 10;
		} else if (filesize > (1l * 1204 * 1024 * 1024)) {
			sbyte = "G";
			r = Math.round((filesize / 1024 / 1024 / 1024) * 10) / 10;
		} else if (filesize > (1l * 1024 * 1024)) {
			sbyte = "M";
			r = Math.round((filesize / 1024 / 1024) * 10) / 10;
		} else if (filesize > (1l * 1024)) {
			sbyte = "K";
			r = Math.round((filesize / 1024) * 10) / 10;
		} else {
			sbyte = "";
			r = filesize;
		}

		return r + sbyte;
	}

	/**
	 * 根据字节转换为KB或者MB
	 * 
	 * @param n
	 *            字节大小
	 * @return
	 */
	public static String ib2mb(long filesize) {
		int r = 0;
		String sbyte = "";
		// System.out.println(""+filesize+">1*1024*1024*1024*1024("+(1l*1024*1024*1024*1024)+"):::"+(filesize>(1l*1024*1024*1024*1024)));
		if (filesize > (1l * 1024 * 1024 * 1024 * 1024)) {
			sbyte = "T";
			r = Math.round(filesize / 1024 / 1024 / 1024 / 1024);
		} else if (filesize > (1l * 1204 * 1024 * 1024)) {
			sbyte = "G";
			r = Math.round(filesize / 1024 / 1024 / 1024);
		} else if (filesize > (1l * 1024 * 1024)) {
			sbyte = "M";
			r = Math.round(filesize / 1024 / 1024);
		} else if (filesize > (1l * 1024)) {
			sbyte = "K";
			r = Math.round(filesize / 1024);
		} else {
			sbyte = "";
			r = Integer.valueOf(String.valueOf(filesize));
		}

		return r + sbyte;
	}

	/**
	 * 读取文件对应的Clas
	 * 
	 * @param file
	 * @return
	 */
	public static String classIcon(String file) {
		String ext = FileUtil.getExtension(file).toLowerCase();
		System.out.println("file=" + file + "  ext=" + ext);
		return "vd_" + ext;
	}

	/**
	 * 格式化时间
	 * 
	 * @param date
	 * @param format
	 * @return
	 */
	public static String dateformat(Date date, String format) {
		SimpleDateFormat _format = new SimpleDateFormat(format);
		return _format.format(date);
	}

	/**
	 * 获取本周一日期
	 * 
	 * @return
	 */
	public static String getMondayDate() {
		GregorianCalendar currentDate = new GregorianCalendar();
		currentDate.add(GregorianCalendar.DATE, getStartWeekNumber());
		Date monday = currentDate.getTime();

		return dateformat(monday, "yyyy-MM-dd");
	}

	/**
	 * 根据week获得本周几的日期
	 * 
	 * @return
	 */
	public static String getWeekDateStr(int week) {
		// 周几的详细Date
		Date end = getWeekDate(week);

		return dateformat(end, "yyyy-MM-dd");
	}

	/**
	 * 根据week获得本周几的日期
	 * 
	 * @return
	 */
	public static Date getWeekDate(int week) {
		Calendar calendar = Calendar.getInstance();
		int min = getStartWeekNumber(); // 获取周开始基准
		// int current = calendar.get(Calendar.DAY_OF_WEEK); //获取当天周内天数
		calendar.add(Calendar.DAY_OF_WEEK, min); // 当天-基准，获取周开始日期
		// 周一?
		// Date start = calendar.getTime();
		// System.out.println("开始日期:"+dateformat(start,"yyyy-MM-dd"));
		calendar.add(Calendar.DAY_OF_WEEK, week); // 获取周几的日期
		// 周几的详细Date
		return calendar.getTime();

	}

	/**
	 * 根据date得到它是周几,
	 * 
	 * @param date
	 * @return 周一返回0,周日返回7
	 */
	public static int getWeek(Date date) {
		Calendar cd = Calendar.getInstance();
		cd.setTime(date);
		// 获得今天是一周的第几天，星期日是第一天，星期二是第二天......
		int dayOfWeek = cd.get(Calendar.DAY_OF_WEEK) - 1; // 因为按中国礼拜一作为第一天所以这里减1
		if (dayOfWeek == 0) { // 如果为0表示今天为周日,返回7
			dayOfWeek = 7;
		}

		if (dayOfWeek == 1) { // 如果是1表示 今天是周一,返回0
			return 0;
		} else {
			return 1 - dayOfWeek;
		}
	}

	/**
	 * 返回星期
	 * 
	 * @param date
	 * @return
	 */
	public static String getWeekStr(String date) {
		DateFormat df = new SimpleDateFormat("yyyy-MM-dd");
		try {
			Date dt1 = df.parse(date);
			return weeks[Math.abs(getWeek(dt1))];
		} catch (Exception exception) {
			exception.printStackTrace();
		}
		return "";
	}

	/**
	 * 获取本周一
	 * 
	 * @return
	 */
	public static int getStartWeekNumber() {
		return getWeek(new Date());
	}

	/**
	 * 比较时间大小
	 * 
	 * @param DATE1
	 *            开始日期
	 * @param DATE2
	 *            结束日期
	 * @return
	 */
	public static int compare_date(String DATE1, String DATE2) {
		DateFormat df = new SimpleDateFormat("yyyy-MM-dd");
		try {
			Date dt1 = df.parse(DATE1);
			Date dt2 = df.parse(DATE2);
			if (dt1.getTime() > dt2.getTime()) {
				// System.out.println("dt1 在dt2前");
				return 1;
			} else if (dt1.getTime() < dt2.getTime()) {
				// System.out.println("dt1在dt2后");
				return -1;
			} else {
				return 0;
			}
		} catch (Exception exception) {
			exception.printStackTrace();
		}
		return 0;
	}

	/**
	 * 将字符型转换为日期型
	 * 
	 * @param date
	 * @return
	 */
	public static Date str2date(String date) {
		return str2date(date,"yyyy-MM-dd HH:mm");
	}
	
	/**
	 * 将字符型转换为日期型
	 * 
	 * @param date
	 * @return
	 */
	public static Date str2date(String date, String format) {
		DateFormat df = new SimpleDateFormat(format);
		try {
			return df.parse(date);
		} catch (Exception exception) {
			exception.printStackTrace();
		}
		return null;
	}

	/**
	 * 将字符型转换为数字型,异常则返回0
	 * 
	 * @param strlong
	 *            字符型
	 * @return
	 */
	public static int str2int(String strlong, int def) {
		try {
			if (StringUtils.isNotEmpty(strlong)) {
				return Integer.parseInt(strlong);
			} else {
				return def;
			}

		} catch (Exception e) {
			return def;
		}
	}
	
	/**
	 * 计算两个日期的时间差,返回几天几小时几分几秒
	 * @param sd
	 * @param ed
	 * @return
	 */
	public static Long date2diff(Date sd, Date ed){
		Long s = sd.getTime();
		Long e = ed.getTime();
		if(s>e){
			Long tmp = s;
			s = e;
			e = tmp;
		}
		
		return e - s;
	}

	/**
	 * 提取年份
	 * <p>
	 * 例如：当现在时间>"09-01"号证明已经过去一学年
	 * </p>
	 * 
	 * @return
	 */
	public static int getYear() {
		Calendar cal = Calendar.getInstance();
		int year = cal.get(Calendar.YEAR);

		String endTime = null;
		endTime = String.valueOf(year) + "-09-01";

		int c = compare_date(endTime);

		if (c < 0)
			year = year - 1;

		return year;
	}

	/**
	 * date1与当前日期比较,等于返回0,大于返回1,小于返回-1
	 * 
	 * @param date
	 * @return
	 */
	public static int compare_date(String date) {
		return compare_date(date, dateformat(new Date(), "yyyy-MM-dd"));
	}

	/**
	 * 比较日期
	 * 
	 * @param d1
	 * @param d2
	 * @return
	 */
	public static int compare_date(Date d1, Date d2) {
		try {
			if (d1.getTime() > d2.getTime()) {
				System.out.println("dt1 在dt2前");
				return 1;
			} else if (d1.getTime() < d2.getTime()) {
				System.out.println("dt1在dt2后");
				return -1;
			} else {
				return 0;
			}
		} catch (Exception exception) {
			exception.printStackTrace();
		}
		return 0;
	}

	/**
	 * 将时间转换为字符串,1小时内转换为文本,1小时后转换为yyyy-MM-dd HH:mm
	 * 
	 * @param date
	 * @return
	 */
	public static String Date2String(Date date) {
		if (date == null)
			return "";

		StringBuffer buffer = new StringBuffer();
		long millTime = System.currentTimeMillis() - date.getTime();
		long second = millTime / 1000;
		long minutes = second / 60;
		long hours = minutes / 60;
		if (second < 60) {
			buffer.append(second).append("秒前");
		} else if (minutes < 60) {
			buffer.append(minutes).append("分钟前");
		} else if (hours < 24) {
			buffer.append(hours).append("小时前");
		} else {
			buffer.append(new SimpleDateFormat("yyyy-MM-dd HH:mm").format(date));
		}
		return buffer.toString();
	}

	/**
	 * d1与当前日期比较
	 * 
	 * @param d1
	 * @return
	 */
	public static int compare_date(Date d1) {
		return compare_date(d1, new Date());
	}

	/**
	 * 返回1-max中的随机数
	 * 
	 * @param max
	 * @return
	 */
	public static long getInt1tomaxRandom(long max) {
		return Math.round(Math.random() * (max - 10) + 8);
	}

	/**
	 * 提取页面图片列表
	 * 
	 * @param html
	 * @return
	 */
	public static List<String> getHtmlImages(String html) {
		String img = "";
		Pattern p_image;
		Matcher m_image;
		List<String> pics = new ArrayList<String>();

		String regEx_img = "<img.*src=(.*?)[^>]*?>"; // 图片链接地址
		p_image = Pattern.compile(regEx_img, Pattern.CASE_INSENSITIVE);
		m_image = p_image.matcher(html);
		while (m_image.find()) {
			img = img + "," + m_image.group();
			Matcher m = Pattern.compile("src=\"?(.*?)(\"|>|\\s+)").matcher(img); // 匹配src
			while (m.find()) {
				String url = m.group(1);
				url = url.replace("'", "");
				pics.add(url);
			}
		}
		return pics;
	}

	/**
	 * 截取标题、文本内容 <li>若文本长度不足len时，返回全部
	 * 
	 * @param text
	 *            原始文本长度
	 * @param len
	 *            截取长度
	 * @return
	 */
	public static String getTextLen(String text, int len) {
		if (text == null || "".equals(text))
			return "";

		text = text.replaceAll("\\&[a-zA-Z]{1,10};", "").replaceAll("<[^>]*>",
				"");
		text = text.replaceAll("[(/>)<]", "");

		if (text.length() >= len) {
			// 去除格式，提取文本内容
			return text.substring(0, len - 1) + "...";
		}
		return text;
	}

	/**
	 * 过滤文本的HTML标签
	 * @param htmlStr
	 * @return
	 */
	public static String delHTMLTag(String htmlStr){ 
		String regEx_script="<script[^>]*?>[\\s\\S]*?<\\/script>"; //定义script的正则表达式   
        String regEx_style="<style[^>]*?>[\\s\\S]*?<\\/style>"; //定义style的正则表达式   
        String regEx_html="<[^>]+>"; //定义HTML标签的正则表达式   
           
        Pattern p_script=Pattern.compile(regEx_script,Pattern.CASE_INSENSITIVE);   
        Matcher m_script=p_script.matcher(htmlStr);   
        htmlStr=m_script.replaceAll(""); //过滤script标签   
           
        Pattern p_style=Pattern.compile(regEx_style,Pattern.CASE_INSENSITIVE);   
        Matcher m_style=p_style.matcher(htmlStr);   
        htmlStr=m_style.replaceAll(""); //过滤style标签   
           
        Pattern p_html=Pattern.compile(regEx_html,Pattern.CASE_INSENSITIVE);   
        Matcher m_html=p_html.matcher(htmlStr);   
        htmlStr=m_html.replaceAll(""); //过滤html标签   

        return htmlStr.trim(); //返回文本字符串   
	}
	
	/**
	 * 将本地文件地址，转换为Web格式
	 * 
	 * @param filePath
	 * @param firstIndex
	 *            Global.FILE_UPLOAD_PATH_LEVEL_FIRST
	 * @return
	 */
	public static String local2url(String filePath, String firstIndex) {
		String webfilepath = "/"
				+ filePath.substring(filePath.indexOf(firstIndex),
						filePath.length());
		try {
			webfilepath = webfilepath.replaceAll("\\\\", "/");
		} catch (Exception e) {
		}

		return webfilepath;
	}

	/**
	 * 字符串重新排序
	 * 
	 * @param sort
	 *            字符串以逗号隔开
	 * @return
	 */
	public static String str2Sort(String sort) {
		if (sort == null || "".equals(sort.trim())) {
			return sort;
		}

		String[] ary = sort.split(",");
		Arrays.sort(ary);

		return StringUtils.join(ary, ",");
	}

	/**
	 * 字符串重新排序
	 * 
	 * @param sort
	 *            字符串以逗号隔开
	 * @return
	 */
	public static String str2Sort2(String sort) {
		if (sort == null || "".equals(sort.trim())) {
			return sort;
		}

		sort = sort.replaceAll("\\[", "").replaceAll("\\]", ",");

		String[] ary = sort.split(",");
		Arrays.sort(ary);

		return StringUtils.join(ary, ",");

	}

	/**
	 * TODO 字符串生成字符分隔 <li>利用正则实现替换
	 * 
	 * @param sort
	 *            字符串以逗号隔开
	 * @return
	 */
	public static String ary2str(String sort, String replacement) {
		if (sort == null || "".equals(sort.trim())) {
			return sort;
		}

		// sort = sort.replaceAll("\\[", "").replaceAll("\\]", ",");
		String[] ary = sort.split(",");
		Arrays.sort(ary);

		StringBuffer result = new StringBuffer();
		for (String item : ary) {
			if ("[]".equals(replacement)) { // 以中括号的形式分开
				result.append("[").append(item).append("]");
			} else if ("{}".equals(replacement)) {// 以大括号的形式分开
				result.append("{").append(item).append("}");
			} else if ("()".equals(replacement)) {// 以小括号的形式分开
				result.append("(").append(item).append(")");
			} else if ("<>".equals(replacement)) {// 以尖括号
				result.append("<").append(item).append(">");
			} else {
				result.append(item).append(replacement);
			}
		}

		return result.toString();

	}

	/**
	 * 计算微博广播发布时间 by wsh
	 * 
	 * @param date
	 * @return
	 */
	public static String getWeiboTime(Date date) {

		if (date == null)
			return "";
		Calendar cal = Calendar.getInstance();
		int year = cal.get(Calendar.YEAR);// 当前年份
		int dateYear = Integer.parseInt(new SimpleDateFormat("yyyy")
				.format(date));// 传入时间年份
		StringBuffer buffer = new StringBuffer();
		long millTime = System.currentTimeMillis() - date.getTime();
		long second = millTime / 1000;
		long minutes = second / 60;
		long hours = minutes / 60;
		if (second < 60) {
			buffer.append("刚刚");
		} else if (minutes < 60) {
			buffer.append(minutes).append("分钟前");
		} else if (hours < 24) {
			buffer.append(hours).append("小时前");
		} else if (dateYear != year) {
			buffer.append(new SimpleDateFormat("yyyy年MM月dd日 HH:mm")
					.format(date));
		} else {
			buffer.append(new SimpleDateFormat("MM月dd日 HH:mm").format(date));
		}
		return buffer.toString();
	}

	/**
	 * 返回是否包含类型
	 *  by wsh
	 * @param contentType
	 * @param type
	 * @return
	 */
	public static boolean getTypeContains(String contentType, String type) {

		return contentType.contains(type);

	}

	/**
	 * 移除数组中重复的元素 by wsh
	 * 
	 * @param arry
	 * @return
	 */
	public static String[] removeRepeat(String arry[]) {
		// 第一步：将字符串数组转化为字符串list；
		List<String> strList = Arrays.asList(arry);
		// 第二步：将字符串list转化为hashset.利用hashset无重复元 素的特性解决问题。
		Set<String> strSet = new HashSet<String>(strList);
		String[] newArray = new String[strSet.size()];
		Iterator<String> ite = strSet.iterator();
		for (int i = 0; ite.hasNext(); i++) {
			newArray[i] = ite.next();
		}
		return newArray;
	}

	/**
	 * 获取字符串中所包含的shortUrl(并移除重复的shortUrl)
	 *  by wsh
	 * @param str
	 * @return String[]
	 */
	public static String[] getShortUrlArray(String str) {

		// 空数组
		String[] s = new String[0];
		if (str.contains("http://v.cn/") && str.contains(" ")) {
			// 将shortUrl分割成多个
			String[] strArray = str.split(" ");
			List<String> strList = new ArrayList<String>();
			for (int i = 0; i < strArray.length; i++) {
				String a = strArray[i];
				if (strArray[i].contains("http://v.cn/")) {
					// 获取shortUrl
					String sUrl = a.substring(a.lastIndexOf("http://v.cn/"),
							a.length())
							+ " ";
					strList.add(sUrl);
				}
			}
			Set<String> strSet = new HashSet<String>(strList);
			String[] newArray = new String[strSet.size()];
			Iterator<String> ite = strSet.iterator();
			for (int i = 0; ite.hasNext(); i++) {
				newArray[i] = ite.next();
			}
			return newArray;
		}
		return s;
	}

	/**
	 * 转换Javabean(PO转换成VO)
	 *  by wsh
	 * @param T
	 * @param T1
	 * @return
	 */
	public static Object convertorBean(Object T, Object T1) {

		try {
			BeanUtils.copyProperties(T, T1);
		} catch (IllegalAccessException e) {
			e.printStackTrace();
		} catch (InvocationTargetException e) {
			e.printStackTrace();
		}

		return T;
	}
	
	/**
	 * 生成有效的长链接
	 * @param extvalue
	 * @return
	 */
	public static String createLink(String domain,String urlString) {
		if(urlString==null || "".equals(urlString)) return  "";
		//boolean isMatch = urlString!=null && "http://".equals(urlString.substring(0, 7)) && urlString.indexOf("https://")==-1;
		//System.out.println("urlString is null="+(urlString!=null));
		//System.out.println("urlString indexOf http://="+(urlString.indexOf("http:")>=0));
		//System.out.println("urlString indexOf https://="+(urlString.indexOf("https:")>=0));
		boolean isMatch = urlString!=null && (urlString.indexOf("http://")>=0 || urlString.indexOf("https://")>=0);
		
		if(!urlString.substring(0, 1).equals("/")){
			domain = domain + "/"; 
		}
		
		if (!isMatch) {
		     return domain + urlString;
		} 
		
		return urlString;
	}
	
	/**
	 * 生成有效的长链接
	 * @param extvalue
	 * @return
	 */
	public static String createLink(String domain,String urlString,String params) {
		if(urlString==null || "".equals(urlString)) return "";
		//boolean isMatch = urlString!=null && "http://".equals(urlString.substring(0, 7)) && urlString.indexOf("https://")==-1;
		//System.out.println("urlString is null="+(urlString!=null));
		//System.out.println("urlString indexOf http://="+(urlString.indexOf("http:")>=0));
		//System.out.println("urlString indexOf https://="+(urlString.indexOf("https:")>=0));
		boolean isMatch = urlString!=null && (urlString.indexOf("http://")>=0 || urlString.indexOf("https://")>=0);
		String url = urlString==null ? "":urlString;
		System.out.println("urlString substring 0-1:="+url.substring(0, 1));
		if(!url.substring(0, 1).equals("/")){
			domain = domain + "/"; 
		}
		
		if (!isMatch) {
			url = domain + url;
		} 
		if(url.indexOf("?")>=0){
			url = url + "&" + params;
		}else{
			url = url + "?" + params;
		}
		
		url = url + params;
		
		
		return url;
	}
	
	
	/**
	 * 下载文件
	 * 
	 * @param filePath
	 * @param response
	 * @return
	 */
	public static HttpServletResponse download(String filePath,
			HttpServletResponse response) {
		try {
			// path是指欲下载的文件的路径。
			File file = new File(filePath);
			// 取得文件名。
			String filename = file.getName();
			// 取得文件的后缀名。
			String ext = filename.substring(filename.lastIndexOf(".") + 1)
					.toUpperCase();
			if (filePath.indexOf("\\.\\") > 0)
				filePath = filePath.replace("/./", "/");

			// 以流的形式下载文件。
			InputStream fis = new BufferedInputStream(new FileInputStream(
					filePath));
			byte[] buffer = new byte[fis.available()];
			fis.read(buffer);
			fis.close();
			// 清空response
			response.reset();
			// 设置response的Header
			// response.addHeader("Content-Disposition", "attachment;filename="
			// + new String(filename.getBytes()));

			response.addHeader(
					"Content-Disposition",
					"attachment;filename="
							+ URLEncoder.encode(new String(filename.getBytes()), "utf-8"));
			response.addHeader("Content-Length", "" + file.length());
			OutputStream toClient = new BufferedOutputStream(response.getOutputStream());
			response.setContentType("application/octet-stream");
			toClient.write(buffer);
			toClient.flush();
			toClient.close();
		} catch (IOException ex) {
			ex.printStackTrace();
		}
		return response;

	}
	
	/**
	 * 保存文件
	 * @param file
	 * @param path
	 * @return
	 */
	public static File saveMultipartFile(MultipartFile file, String path) throws Exception{
		// 项目根路径
		//** 文件名字 *//*
		String fileName = "tmp_" + String.valueOf(System.currentTimeMillis()); 
		//** 截取获得文件后缀名 *//*
		String fileSuffix = file.getOriginalFilename().substring(
				file.getOriginalFilename().lastIndexOf("."));
		//文件路径
		String weiboPath = File.separator + "upload" + File.separator 
				+  path + File.separator + dateformat(new Date(), "yyyyMMdd") + File.separator;
		//** 真实路径 *//*
		String uploadRealPath = EnvProperUtil.webrealpath + weiboPath + fileName + fileSuffix;
		File realPath = new File(uploadRealPath);
		try {
			realPath.mkdirs();
		} catch (Exception e) {
		}
		// 上传图片
		file.transferTo(realPath);
		
		return realPath;
	}
	
	public static void main(String[] args) {
		//System.out.println(createLink("http://www.tombaba.cn","/weiweb/1/home?a=1"));
		//System.out.println(createLink("http://www.tombaba.cn","/weiweb/1/home?a=1","token=%s&sid=%s"));
		
		System.out.println(delHTMLTag("愿赠于它一对完整的翅膀<img src='http://wei.linkbo.net//upload/wishes/1405017822909thumb.jpg' style='width:198px; height:auto;'></img>"));
	}

}
