package edu.minilive.wedu.service.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

import edu.ecompus.core.entity.Page;
import edu.ecompus.core.service.GenerateService;
import edu.minilive.wedu.dao.WeiXiTieBlessingDAO;
import edu.minilive.wedu.dao.WeiXiTieDAO;
import edu.minilive.wedu.entity.Company;
import edu.minilive.wedu.entity.app.WeiXiTie;
import edu.minilive.wedu.entity.app.WeiXiTieBlessing;
import edu.minilive.wedu.service.WeiXiTieService;


/**
 * 微喜帖服务层
 * 
 * 
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-4-1 下午4:22:27
 */
@Service("weiXiTieService")
public class WeiXiTieServiceImpl extends GenerateService implements
		WeiXiTieService {
	
	@Autowired
	WeiXiTieDAO weiXiTieDAO;
	
	@Autowired
	WeiXiTieBlessingDAO weiXiTieBlessingDAO;
	
	@Cacheable(value="default",key="'WeiXiTie-cache-by' + #id")
	@Override
	public WeiXiTie getWeiXiTieById(Long id) {
		return weiXiTieDAO.query(id);
	}

	@Override
	public WeiXiTie getWeiXiTieByToken(String token) {
		// TODO Auto-generated method stub
		return null;
	}

	@Cacheable(value="default",key="'WeiXiTieList-cache-byCompany' + #company.id + 'p' + #page.pageIndex")
	@Override
	public List<WeiXiTie> getWeiXiTieByCompany(Company company, Page page) {
		return weiXiTieDAO.queryWeiXiTieByCompany(company, page);
	}

	@Override
	public WeiXiTieBlessing createNewWeiXiTieBlessing(
			WeiXiTieBlessing weiXiTieBlessing) {
		weiXiTieBlessingDAO.create(weiXiTieBlessing);
		return weiXiTieBlessing;
	}

}
