package edu.minilive.wedu.service.impl;

import java.util.Collections;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

import edu.ecompus.core.entity.Page;
import edu.ecompus.core.service.GenerateService;
import edu.minilive.wedu.dao.WeiVideoConfigDAO;
import edu.minilive.wedu.dao.WeiVideoDAO;
import edu.minilive.wedu.entity.Company;
import edu.minilive.wedu.entity.User;
import edu.minilive.wedu.entity.app.WeiVideo;
import edu.minilive.wedu.entity.app.WeiVideoConfig;
import edu.minilive.wedu.service.WeiVideoService;

/**
 * <b>教育微频-微应用</b> 服务层接口实现 
 * 
 * 
 * CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2013-12-9 下午3:18:58
 */
@Service("weivideoService")
public class WeiVideoServiceImpl extends GenerateService implements
		WeiVideoService {
	
	@Autowired
	WeiVideoDAO weiVideoDAO;
	
	@Autowired 
	WeiVideoConfigDAO weiVideoConfigDAO;
	
	@Cacheable(value="default",key="'WeiVideo-cache-by' + #id")
	@Override
	public WeiVideo getWeiVideoById(Long id) {
		return weiVideoDAO.query(id);
	}
	
	@Override
	public WeiVideo createWeiVideo(WeiVideo weiVideo) {
		weiVideoDAO.create(weiVideo);
		return weiVideo;
	}

	@CacheEvict(value="default",key="'WeiVideo-cache-by' + #weiVideo.id")
	@Override
	public void updateWeiVideo(WeiVideo weiVideo) {
		weiVideoDAO.update(weiVideo);
	}

	@CacheEvict(value="default",key="'WeiVideo-cache-by' + #weiVideo.id")
	@Override
	public void deleteWeiVideo(WeiVideo weiVideo) {
		weiVideoDAO.delete(weiVideo);
	}
	
	@Cacheable(value="default",key="'WeiVideoList-cache-byCompany' + #company.id")
	@Override
	public List<WeiVideo> getCompanyVideo(Company company, Page page) {
		if(company!=null){
			return weiVideoDAO.queryCompanyVideo(company,page);
		}
		
		return Collections.emptyList(); 
	}

	@CacheEvict(value="default",key="'WeiVideo-cache-by' + #videoId")
	@Override
	public void updateVideoStatus(Long videoId, int status) {
		weiVideoDAO.updateVideoStatus(videoId, status);
	}

	
	@Override
	public List<WeiVideo> getVideoList(String title, int status, User user,
			Company company, int subject, Page page) {
		return weiVideoDAO.queryVideoList(title, status, user, company, subject, page);
	}

	@Cacheable(value="default",key="'WeiVideoConfig-cache-by' + #company.id")
	@Override
	public WeiVideoConfig getWeiVideoConfigByCompany(Company company) {
		if(company!=null){
			return weiVideoConfigDAO.queryWeiVideoConfigByCompany(company);
		}
		
		return null;
	}

	@Override
	public WeiVideoConfig createWeiVideoConfig(WeiVideoConfig weiVideoConfig) {
		weiVideoConfigDAO.create(weiVideoConfig);
		return weiVideoConfig;
	}

	@Override
	public void updateWeiVideoConfig(WeiVideoConfig weiVideoConfig) {
		weiVideoConfigDAO.update(weiVideoConfig);
	}

	@Override
	public void deleteWeiVideoConfig(WeiVideoConfig weiVideoConfig) {
		weiVideoConfigDAO.delete(weiVideoConfig);
	}
	
	

	

	

}
