package edu.minilive.wedu.service.impl;

import java.util.Collections;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

import edu.ecompus.core.entity.Page;
import edu.ecompus.core.service.GenerateService;
import edu.minilive.wedu.dao.WeiPhotoDAO;
import edu.minilive.wedu.entity.Company;
import edu.minilive.wedu.entity.app.WeiAlbum;
import edu.minilive.wedu.entity.app.WeiPhoto;
import edu.minilive.wedu.service.WeiPhotoService;

/**
 * 微相册（微应用） 服务层接口实现 
 * 
 * 
 * CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2013-12-9 下午3:18:58
 */
@Service("weiphotoService")
public class WeiPhotoServiceImpl extends GenerateService implements WeiPhotoService {
	
	@Autowired
	WeiPhotoDAO photoDAO;
	
	@Cacheable(value="default",key="'Photo-cache-by' + #id")
	@Override
	public WeiPhoto getPhotoById(Long id) {
		return photoDAO.query(id);
	}
	
	@Override
	public WeiPhoto addWeiPhoto(WeiPhoto weiPhoto) {
		photoDAO.create(weiPhoto);
		return weiPhoto;
	}

	@CacheEvict(value="default",key="'Photo-cache-by' + #weiPhoto.id")
	@Override
	public void editWeiPhoto(WeiPhoto weiPhoto) {
		photoDAO.update(weiPhoto);
	}

	@Override
	public List<WeiPhoto> getPhotoListByToken(String token, Company company,
			Page page) {
		return photoDAO.queryPhotoListByToken(token, company, page);
	}

	@Override
	public List<WeiPhoto> getPhotoListByCompany(String title, Company company,
			WeiAlbum weiAlbum, Page page) {
		if(company==null && weiAlbum==null ){
			return Collections.emptyList(); 
		}
		
		return photoDAO.queryPhotoListByCompany(title, company, weiAlbum, page);
	}



	@Override
	public List<WeiPhoto> getPhotoListByIds(String photoIds, Company company,
			WeiAlbum weiAlbum, Page page) {
		return photoDAO.queryPhotoListByIds(photoIds,company,weiAlbum,page);
	}

	@Override
	public Long countAlbumPhoto(WeiAlbum weiAlbum) {
		return photoDAO.countAlbumPhoto(weiAlbum);
	}

}
