package edu.minilive.wedu.service.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

import edu.ecompus.core.entity.Page;
import edu.ecompus.core.service.GenerateService;
import edu.minilive.wedu.dao.UpdateLogDAO;
import edu.minilive.wedu.entity.UpdateLog;
import edu.minilive.wedu.service.UpdateLogService;

/**
 * 平台历史更新日志服务层	实现类
 * 
 * 
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-4-1 下午4:22:27
 */
@Service("updateLogService")
public class UpdateLogServiceImpl extends GenerateService implements
		UpdateLogService {
	
	@Autowired
	UpdateLogDAO updateLogDAO;
	
	@Cacheable(value="default",key="'UpdateLog-cache-by' + #id")
	@Override
	public UpdateLog getUpdateLogById(Long id) {
		return updateLogDAO.query(id);
	}
	
	@CacheEvict(value="default",key="'UpdateLog-cache-by' + #updatelog.id")
	@Override
	public void deleteUpdateLog(UpdateLog updatelog) {
		updateLogDAO.delete(updatelog);
	}

	@Override
	public List<UpdateLog> getUpdateLogList(Page page) {
		return updateLogDAO.queryNewestList(page);
	}

	

}
