package edu.minilive.wedu.service.impl;

import java.util.Collections;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

import edu.ecompus.core.entity.Page;
import edu.ecompus.core.service.GenerateService;
import edu.minilive.wedu.dao.FocusAdDAO;
import edu.minilive.wedu.entity.Company;
import edu.minilive.wedu.entity.FocusAd;
import edu.minilive.wedu.service.FocusAdService;

/**
 * <b>焦点广告</b> 服务层接口实现
 * 
 * 
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-4-2 上午11:32:13
 */
@Service("fouseAdService")
public class FocusAdServiceImpl extends GenerateService implements
		FocusAdService {
	
	@Autowired
	FocusAdDAO focusAdDAO;
	
	@Override
	public FocusAd addFocusAd(FocusAd fouseAd) {
		focusAdDAO.create(fouseAd);
		return fouseAd;
	}

	@CacheEvict(value="default",key="'focusAd-cache-by' + #focusAd.id")
	@Override
	public FocusAd updateFocusAd(FocusAd focusAd) {
		focusAdDAO.update(focusAd);
		return focusAd;
	}

	@Cacheable(value="default",key="'focusAd-cache-by' + #id")
	@Override
	public FocusAd getFocusAdById(Long id) {
		return focusAdDAO.query(id);
	}

	@Override
	public List<FocusAd> getFocusAdByCompany(Company company, String keyword,
			int type, Page page) {
		if(company==null){
			return Collections.emptyList();
		}
		
		return focusAdDAO.queryFocusAdByCompany(company, keyword, type, page);
	}

	@Override
	public List<FocusAd> getFocusAdByType(int type) {
		if(type==-1){
			return Collections.emptyList();
		}
		
		return focusAdDAO.queryFocusAdByType(type);
	}

}
