package edu.minilive.wedu.service.impl;

import java.util.Collections;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

import edu.ecompus.core.service.GenerateService;
import edu.minilive.wedu.dao.DistrictDAO;
import edu.minilive.wedu.entity.District;
import edu.minilive.wedu.service.DistrictService;

/**
 * 区域位置服务层
 * 
 * 
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-4-1 下午4:22:27
 */
@Service("distictService")
public class DistrictServiceImpl extends GenerateService implements
		DistrictService {
	
	@Autowired
	DistrictDAO districtDAO;
	
	@Override
	public District addDistrict(District district) {
		districtDAO.create(district);
		return district;
	}

	@Override
	public void updateDistrict(District district) {
		districtDAO.update(district);
	}

	@Override
	public void delDistrict(District district) {
		districtDAO.delete(district);
	}
	
	@Cacheable(value="default",key="'district-cache-by' + #id")
	@Override
	public District getDistrictById(Long id) {
		return districtDAO.query(id);
	}

	@Cacheable(value="default",key="'district-provincelist'")
	@Override
	public List<District> getAllProvince() {
		return districtDAO.queryAllProvince();
	}
	

	@Cacheable(value="default",key="'district-citylist-p' + #provinceId ")
	@Override
	public List<District> getCityList(Long provinceId) {
		return districtDAO.queryCityList(provinceId);
	}



	@Override
	public List<District> getDistrictListByIds(String ids) {
		return districtDAO.queryDistrictListByIds(ids);
	}

	@Cacheable(value="default",key="'district-arealist-c' + #cityId ")
	@Override
	public List<District> getAreaList(Long cityId) {
		return districtDAO.queryAreaList(cityId);
	}

	@Override
	public List<District> getFuzzy(String name, int level) {
		if(name!=null && !"".equals(name)){
			return districtDAO.queryFuzzy(name, level);
		}
		
		return Collections.emptyList();
	}

	@Override
	public District getDistrictFuzzy(String name, int level) {
		List<District> list = getFuzzy(name,level);
		if(list.size()>0){
			return list.get(0);
		}
		
		return null;
	}

}
