package edu.minilive.wedu.service.impl;

import java.util.Collections;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

import edu.ecompus.core.entity.Page;
import edu.ecompus.core.service.GenerateService;
import edu.minilive.wedu.dao.CustomMenuDAO;
import edu.minilive.wedu.entity.Company;
import edu.minilive.wedu.entity.CustomMenu;
import edu.minilive.wedu.service.CustomMenuService;
/**
 * 
 * 
 * 
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-4-2 下午4:10:00
 */
@Service("custommenuService")
public class CustomMenuServiceImpl extends GenerateService implements
		CustomMenuService {
	
	@Autowired
	CustomMenuDAO customMenuDAO;

	@Override
	public CustomMenu addCustomMenu(CustomMenu customMenu) {
		customMenuDAO.create(customMenu);
		return customMenu;
	}

	@Cacheable(value="default",key="'CustomMenu-cache-by' + #id")
	@Override
	public CustomMenu getCustomMenuById(Long id) {
		return customMenuDAO.query(id);
	}

	@CacheEvict(value="default",key="'CustomMenu-cache-by' + #customMenu.id")
	@Override
	public CustomMenu updateCustomMenu(CustomMenu customMenu) {
		customMenuDAO.update(customMenu);
		return customMenu;
	}

	@Override
	public List<CustomMenu> getCustomMenuListByCompanyId(Company school,
			int level) {
		
		if(school==null){
			return Collections.emptyList();
		}
		
		return customMenuDAO.queryCustomMenuListByCompanyId(school.getId(), level); 
	}

	@Cacheable(value="default",key="'CustomMenu-cache-by-eventKey-' + #eventKey")
	@Override
	public CustomMenu getCustomMenuByEventKey(String eventKey) {
		if(eventKey==null || "".equals(eventKey)){
			return null;
		}
		
		List<CustomMenu> list = customMenuDAO.queryCustomMenuByEventKey(eventKey, new Page(1,1)); 
		if(list.size()>0){
			return list.get(0);
		}
		
		return null;
	}
}
