package edu.minilive.wedu.service.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import edu.ecompus.core.service.GenerateService;
import edu.minilive.wedu.dao.CompanyAppDAO;
import edu.minilive.wedu.entity.App;
import edu.minilive.wedu.entity.Company;
import edu.minilive.wedu.entity.CompanyApp;
import edu.minilive.wedu.service.CompanyAppService;

/**
 * <b>单位应用</b> 服务层接口实现
 * 
 * 
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-2-25 上午10:46:45
 */
@Service("companyAppService")
public class CompanyAppServiceImpl extends GenerateService implements
		CompanyAppService {
	
	@Autowired
	CompanyAppDAO companyAppDAO;

	
	@Override
	public CompanyApp createCompanyApp(CompanyApp companyApp) {
		companyAppDAO.create(companyApp);
		return companyApp;
	}

	@Override
	public void updateCompanyApp(CompanyApp companyApp) {
		companyAppDAO.update(companyApp);
	}
	
	@Override
	public List<CompanyApp> getCompanyAppList(Company school,String appalias, App app,  int apptype,int state, int showApp) {
		return companyAppDAO.queryCompanyApp(school,appalias,app, apptype, state, showApp);
	}

	@Override
	public CompanyApp getCompanyApp(Company company, String appalias) {
		List<CompanyApp> list = getCompanyAppList(company,appalias,null,-1,1,-1);
		if(list.size()>0){
			return list.get(0);
		}
		
		return null;
	}

	

}
