package edu.minilive.wedu.service.impl;

import java.util.Collections;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

import edu.ecompus.core.entity.Page;
import edu.ecompus.core.service.GenerateService;
import edu.minilive.wedu.dao.AutoRespondDAO;
import edu.minilive.wedu.entity.AutoRespond;
import edu.minilive.wedu.entity.Company;
import edu.minilive.wedu.service.AutoRespondService;

/**
 * <b>自动回复</b> 服务层接口实现
 * 
 * 
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-4-2 上午11:32:13
 */
@Service("autorespondService")
public class AutoRespondServiceImpl extends GenerateService implements
		AutoRespondService {
	
	@Autowired
	AutoRespondDAO autoRespondDAO;

	@Override
	public AutoRespond addAutoRespond(AutoRespond autoRespond) {
		if(autoRespond!=null){
			autoRespondDAO.create(autoRespond);
		}
		
		return autoRespond;
	}


	@Cacheable(value="default",key="'AutoRespond-cache-by' + #id")
	@Override
	public AutoRespond getAutoRespondById(Long id) {
		return autoRespondDAO.query(id);
	}


	@CacheEvict(value="default",key="'AutoRespond-cache-by' + #autoRespond.id")
	@Override
	public AutoRespond updateAutoRespond(AutoRespond autoRespond) {
		autoRespondDAO.update(autoRespond);
		return autoRespond;
	}
	
	@Override
	public List<AutoRespond> getAutoRespondListByCompany(Company school,
			Page page) {
		if(school==null){
			return Collections.emptyList();
		}
		
		return autoRespondDAO.queryAutoRespondListByCompany(school.getId(), page);
	}


	@Override
	public List<AutoRespond> getAutoRespondListByType(Company school, int type,
			Page page) {
		if(school==null){
			return Collections.emptyList();
		}
		return autoRespondDAO.queryAutoRespondListByType(school.getId(), type, page);
	}


	@Override
	public AutoRespond getAutoRespondByClickKey(Company school, String keyId) {
		if(school==null || keyId==null || "".equals(keyId)){
			return null;
		}
		
		List<AutoRespond> list = autoRespondDAO.queryAutoRespondByClickKeyLike(school.getId(), keyId, new Page(1,1));
		if(list.size()>0){
			return list.get(0);
		}
		
		return null;
	}


	
	
}
