package edu.minilive.wedu.service.impl;

import java.util.Collections;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

import edu.ecompus.core.entity.Page;
import edu.ecompus.core.service.GenerateService;
import edu.minilive.wedu.dao.ArticleDAO;
import edu.minilive.wedu.entity.Article;
import edu.minilive.wedu.entity.User;
import edu.minilive.wedu.service.ArticleService;
/**
 * <b>文章</b> 服务层接口实现
 * 
 * 
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-4-2 上午11:32:13
 */
@Service("articleService")
public class ArticleServiceImpl extends GenerateService implements
		ArticleService {
	
	@Autowired
	ArticleDAO articleDAO;
	
	@Override
	public Article addArticle(Article article) {
		articleDAO.create(article);
		return article;
	}

	@Cacheable(value="default",key="'article-cache-by' + #id")
	@Override
	public Article getArticleById(Long id) {
		return articleDAO.query(id);
	}

	@CacheEvict(value="default",key="'article-cache-by' + #article.id")
	@Override
	public Article updateArticle(Article article) {
		articleDAO.update(article);
		return article;
	}


	@Override
	public List<Article> getChannelList(Long channelId, Page page) {
		return articleDAO.queryChannelList(channelId, page);
	}

	@Override
	public List<Article> getArticleByUser(User user, Page page) {
		return articleDAO.queryArticleByUser(user, page);
	}

	@Override
	public List<Article> getArticleByKeyword(String keyword, Page page) {
		return articleDAO.queryArticleByKeyword(keyword, page);
	}

	@Override
	public List<Article> getArticleByTag(String tag, Page page) {
		return articleDAO.queryArticleByTag(tag, page);
	}

	
	@Override
	public List<Article> getArticleListByCompany(Long companyId, String keyword, Long channelId, Page page) {
		if(companyId==null || companyId<=0){
			return Collections.emptyList();
		}
		
		return articleDAO.queryArticleListByCompany(companyId, keyword, channelId, page);
	}

}
