package edu.minilive.wedu.service;

import java.util.List;

import org.springframework.transaction.annotation.Transactional;

import edu.ecompus.core.entity.Page;
import edu.minilive.wedu.entity.User;

/**
 * <b>用户</b> 服务层接口定义
 * 
 * 
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-2-24 下午2:15:44
 */
@Transactional
public interface UserService {
	
	/**
	 * 创建用户
	 * @param company
	 */
	void creatUser(User user);
	
	/**
	 * 变更用户
	 * @param user
	 */
	void updateUser(User user);
	
	
	/**
	 * 根据用户名查询用户信息
	 * @param userName
	 * @return
	 */
	User getUserByUserName(String userName);
	
	/**
	 * 根据userId查询用户信息
	 * @param userId
	 * @return
	 */
	User getUserByUserId(Long userId);
	
	/**
	 * 综合查询用户列表
	 * @param username		用户昵称（NULL、空不为条件）
	 * @param enable		是否禁用（-1不为条件，1-正常,2-禁用）
	 * @param page			分页
	 * @return
	 */
	List<User> getUserList(String username, int enable, Page page);
}

