package edu.minilive.wedu.service;

import java.util.List;

import org.springframework.transaction.annotation.Transactional;

import edu.ecompus.core.entity.Page;
import edu.minilive.wedu.entity.AutoRespond;
import edu.minilive.wedu.entity.Company;

/**
 * <b>自动回复</b> 服务层接口定义
 * 
 * 
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-4-2 上午11:30:06
 */
@Transactional
public interface AutoRespondService {
	/**
	 * 新增自动回复
	 * @param article
	 * @return
	 */
	AutoRespond addAutoRespond(AutoRespond autoRespond);
	
	
	
	/**
	 * 根据ID读取（带缓存）
	 * @param id
	 * @return
	 */
	AutoRespond getAutoRespondById(Long id);
	
	/**
	 * 根据keyId
	 * @param keyId
	 * @return
	 */
	AutoRespond getAutoRespondByClickKey(Company school,String keyId);
	
	/**
	 * 更新文章内容
	 * @param article
	 * @return
	 */
	AutoRespond updateAutoRespond(AutoRespond autoRespond);

	/**
	 * 读取学校自动回复列表
	 * @param school
	 * @param page
	 * @return
	 */
	List<AutoRespond> getAutoRespondListByCompany(Company school, Page page);

	/**
	 * 读取学校自动回复列表
	 * @param school	企事业单位
	 * @param type		类型0-关注时欢迎消息，1-文字，2-图文
	 * @param page
	 * @return
	 */
	List<AutoRespond> getAutoRespondListByType(Company school, int type, Page page);



	
	
	
	
}
