package edu.minilive.wedu.service;

import org.springframework.transaction.annotation.Transactional;

import edu.minilive.wedu.entity.App;


/**
 * 微应用服务
 * 
 * 
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-4-1 下午4:20:15
 */
@Transactional
public interface AppService {
	
	/**
	 * 创建APP
	 */
	App addApp(App app);
	
	/**
	 * 根据ID读取（带缓存）
	 * @param id
	 * @return
	 */
	App getAppById(Long id);
	
	/**
	 * 更新内容
	 * @return
	 */
	App updateApp(App app);
	
	/**
	 * 根据别名读取App
	 * @param alias
	 * @return
	 */
	App getAppByAlias(String alias);
}
