package edu.minilive.wedu.module.VO;

import java.util.ArrayList;
import java.util.List;

import org.springframework.web.multipart.MultipartFile;

import edu.minilive.wedu.entity.Company;
import edu.minilive.wedu.entity.User;


import lombok.Data;

/**
 * 机构表单
 * 
 * 
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-6-9 上午9:36:35
 */
public @Data class CompanyFormVO {
	private Long id;
	/**
	 * 机构账号
	 */
	private User adminuser;
	/**
	 * 机构信息
	 */
	private Company company;
	
	private Long provinceId;
	
	private Long cityId;
	private String cityname;
	
	/**
	 * 机构电话  1-区号，2-号码，3-分机号
	 */
	private String telphone1 = "";
	private String telphone2 = "";
	private String telphone3= "";
	/**
	 * 头像
	 */
	private int icuserfacef = 0;
	private MultipartFile userfacef;
	
	/**
	 * 证件复印件
	 */
	private int icidentityf=0;
	private MultipartFile identityf;
	
	/**
	 * 营业执照复印件
	 */
	private int icbusinesslicensef=0;
	private MultipartFile businesslicensef;
	
	/**
	 * 组织机构代码证复印件
	 */
	private int icorgcodef=0;
	private MultipartFile orgcodef;
	
	/**
	 * 错误信息
	 */
	private List<String> errs = new ArrayList<String>();
	
	private boolean iserror = false;
	
	private boolean isimported = false;
	
	public String getTelphone(){
		return String.format("%s-%s-%s", telphone1,telphone2,telphone3);
	}
}
