package edu.minilive.wedu.module.VO;


import edu.minilive.wedu.entity.Channel;
import lombok.Data;

/**
 * 栏目可视化数据对象
 * 
 * 
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-5-21 上午10:29:10
 */
public @Data class ChannelVO {
	private Long id = 0l; 
	
	/**频道名称**/
	private String name; 
	
	/**频道别名**/
	private String alias;
	
	/**微信上提醒的功能标题**/
	private String title;
	
	/**
	 * 文章条数（文章添加，修改时做处理）
	 */
	private String articleCount ;
	
	/**
	 * clickType=click:	图片,如使用name做为标题,clickValue保存一张图片,WxSendNewsMsg.addItem
	 * 推荐尺寸：320×160
	 */
	private String img;
	
	public ChannelVO(Channel c) {
		setData(c);
	}
	
	/**
	 * 设置数据（来源Channel）
	 * @param channel
	 */
	public void setData(Channel channel){
		if(channel==null) return;
		this.name = channel.getName();
		this.id = channel.getId();
		this.alias = channel.getAlias();
		this.title = channel.getTitle();
		this.articleCount = String.valueOf(channel.getArticleCount());
		this.img = channel.getImg();
	}

	
}
